/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class Tuples
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IExpr arg1 = ast.arg1();
        if (ast.size() == 2 && arg1.isListOfLists()) {
            try {
                IAST list = (IAST)arg1;
                IAST result = F.List();
                IAST temp = F.List();
                this.tuplesOfLists(list, 1, result, temp);
                return result;
            }
            catch (ArithmeticException ae) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ast.size() == 3 && arg1.isAST() && ((IExpr)ast.get(2)).isInteger()) {
            IExpr arg2 = (IExpr)ast.get(2);
            try {
                int k = ((IInteger)arg2).toInt();
                IAST result = F.List();
                IAST temp = F.List();
                this.tuples((IAST)arg1, k, result, temp);
                return result;
            }
            catch (ArithmeticException ae) {
                // empty catch block
            }
        }
        return null;
    }

    private void tuples(IAST originalList, int n, IAST result, IAST subResult) {
        if (n == 0) {
            result.add(subResult);
            return;
        }
        IAST temp = null;
        for (int j = 1; j < originalList.size(); ++j) {
            temp = subResult.clone();
            temp.add(originalList.get(j));
            this.tuples(originalList, n - 1, result, temp);
        }
    }

    private void tuplesOfLists(IAST originalList, int k, IAST result, IAST subResult) {
        if (k == originalList.size()) {
            result.add(subResult);
            return;
        }
        IAST temp = null;
        IAST subAST = (IAST)originalList.get(k);
        for (int j = 1; j < subAST.size(); ++j) {
            temp = subResult.clone();
            temp.add(subAST.get(j));
            this.tuplesOfLists(originalList, k + 1, result, temp);
        }
    }
}

