/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.LevelSpecification;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.combinatoric.KSubsetsList;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Subsets
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        if (ast.arg1().isAST()) {
            IAST f = (IAST)ast.arg1();
            int n = f.size() - 1;
            LevelSpecification level = ast.size() == 3 ? new LevelSpecification((IExpr)ast.get(2), false) : new LevelSpecification(0, n);
            IAST result = F.ast(f.head());
            level.setFromLevelAsCurrent();
            while (level.isInRange()) {
                int k = level.getCurrentLevel();
                KSubsetsList iter = KSubsetsList.createKSubsets(f, k, F.ast(F.List), 1);
                int i = 0;
                for (IAST part : iter) {
                    if (part == null) break;
                    result.add(part);
                    ++i;
                }
                level.incCurrentLevel();
            }
            return result;
        }
        return null;
    }
}

