/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.structure.MonoidElem;
import org.matheclipse.core.builtin.function.NumericQ;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Sign
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        IExpr result;
        Validate.checkSize(ast, 2);
        IExpr arg1 = ast.arg1();
        if (arg1.isNumber()) {
            return this.numberSign((INumber)arg1);
        }
        if (NumericQ.CONST.apply(arg1) && (result = F.evaln(arg1)).isSignedNumber()) {
            return this.numberSign((INumber)result);
        }
        return null;
    }

    public IExpr numberSign(INumber arg1) {
        if (arg1.isSignedNumber()) {
            int signum = ((ISignedNumber)arg1).sign();
            return F.integer(signum);
        }
        if (arg1.isComplex()) {
            IComplex c = (IComplex)arg1;
            return F.Times((IExpr)c, (IExpr)F.Power(c.eabs(), F.CN1));
        }
        if (arg1.isComplexNumeric()) {
            IComplexNum c = (IComplexNum)arg1;
            return (IExpr)c.divide((MonoidElem)F.num(c.dabs()));
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }
}

