/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class RootIntervals
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        return RootIntervals.croots(ast.arg1(), false);
    }

    public static IAST croots(IExpr arg, boolean numeric) {
        try {
            ExprVariables eVar = new ExprVariables(arg);
            if (!eVar.isSize(1)) {
                return null;
            }
            IExpr expr = F.evalExpandAll(arg);
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            List<IExpr> varList = r.toList();
            ComplexRing cfac = new ComplexRing((RingFactory)new BigRational(1L));
            ComplexRootsSturm cr = new ComplexRootsSturm((RingFactory)cfac);
            JASConvert jas = new JASConvert((List<? extends IExpr>)varList, cfac);
            GenPolynomial poly = jas.numericExpr2JAS(expr);
            SquarefreeAbstract engine = SquarefreeFactory.getImplementation((RingFactory)cfac);
            poly = engine.squarefreePart(poly);
            List roots = cr.complexRoots(poly);
            BigRational len = new BigRational(1L, 100000L);
            IAST resultList = F.List();
            if (numeric) {
                for (Rectangle root : roots) {
                    Rectangle refine = cr.complexRootRefinement(root, poly, len);
                    resultList.add(JASConvert.jas2Numeric((Complex<BigRational>)refine.getCenter(), 1.0E-5));
                }
            } else {
                for (Rectangle root : roots) {
                    IAST rectangleList = F.List();
                    Rectangle refine = cr.complexRootRefinement(root, poly, len);
                    rectangleList.add(JASConvert.jas2Complex((Complex<BigRational>)refine.getNW()));
                    rectangleList.add(JASConvert.jas2Complex((Complex<BigRational>)refine.getSW()));
                    rectangleList.add(JASConvert.jas2Complex((Complex<BigRational>)refine.getSE()));
                    rectangleList.add(JASConvert.jas2Complex((Complex<BigRational>)refine.getNE()));
                    resultList.add(rectangleList);
                }
            }
            return resultList;
        }
        catch (InvalidBoundaryException e) {
            e.printStackTrace();
        }
        catch (JASConversionException e) {
            e.printStackTrace();
        }
        return null;
    }
}

