/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrappedException;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Part
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() >= 3 && ast.arg1().isAST()) {
            return this.getPart(ast.getAST(1), ast, 2);
        }
        return null;
    }

    private IExpr getPart(IExpr expr1, IAST ast, int pos) {
        if (!expr1.isAST()) {
            throw new WrongArgumentType(ast, expr1, pos, "Wrong argument for Part[] function. Function or list expected.");
        }
        IAST arg1 = (IAST)expr1;
        IExpr arg2 = (IExpr)ast.get(pos);
        int p1 = pos + 1;
        IExpr temp = null;
        if (arg2.isSignedNumber()) {
            int indx = Validate.checkIntType(ast, pos, Integer.MIN_VALUE);
            IExpr ires = null;
            ires = this.getIndex(arg1, indx);
            if (p1 < ast.size()) {
                return this.getPart(ires, ast, p1);
            }
            return ires;
        }
        if (arg2.isList()) {
            IAST lst = (IAST)arg2;
            IAST result = F.List();
            for (int i = 1; i < lst.size(); ++i) {
                IExpr expr = (IExpr)lst.get(i);
                if (!expr.isInteger()) continue;
                IExpr ires = null;
                int indx = Validate.checkIntType(lst, i, Integer.MIN_VALUE);
                ires = this.getIndex(arg1, indx);
                if (ires == null) {
                    return null;
                }
                if (p1 < ast.size()) {
                    temp = this.getPart(ires, ast, p1);
                    result.add(temp);
                    continue;
                }
                result.add(ires);
            }
            return result;
        }
        throw new WrongArgumentType(ast, arg2, pos, "Wrong argument for Part[] function");
    }

    IExpr getIndex(IAST ast, int position) {
        if (position < 0) {
            position = ast.size() + position;
        }
        if (position < 0 || position >= ast.size()) {
            throw new WrappedException(new IndexOutOfBoundsException("Part[] index " + position + " of " + ast.toString() + " is out of bounds."));
        }
        return (IExpr)ast.get(position);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(16384);
    }
}

