/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class NextPrime
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        if (ast.size() == 2 && ast.arg1().isInteger()) {
            BigInteger primeBase = ((IntegerSym)ast.arg1()).getBigNumerator();
            return F.integer(primeBase.nextProbablePrime());
        }
        if (ast.size() == 3 && ast.arg1().isInteger() && ast.arg2().isInteger()) {
            BigInteger primeBase = ((IntegerSym)ast.arg1()).getBigNumerator();
            int n = Validate.checkIntType(ast, 2, 1);
            BigInteger temp = primeBase;
            for (int i = 0; i < n; ++i) {
                temp = temp.nextProbablePrime();
            }
            return F.integer(temp);
        }
        return null;
    }
}

