/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.PartialFractionGenerator;
import org.matheclipse.core.reflection.system.Apart;

public class Limit
extends AbstractFunctionEvaluator {
    static final IAST RULES = F.List(F.SetDelayed(F.Limit(F.Power((IExpr)F.$p(F.x), F.$p(F.n, (IExpr)F.$s("IntegerQ"))), F.Rule(F.$p(F.x, (IExpr)F.SymbolHead), F.CInfinity)), F.Condition(F.C0, F.Negative(F.n))), F.SetDelayed(F.Limit(F.Power((IExpr)F.$p(F.x), F.$p(F.n, (IExpr)F.$s("IntegerQ"))), F.Rule(F.$p(F.x, (IExpr)F.SymbolHead), F.CNInfinity)), F.Condition(F.C0, F.Negative(F.n))), F.Set(F.Limit(F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)F.$p(F.x), F.CN1)), F.$p(F.x)), F.Rule(F.$p(F.x, (IExpr)F.SymbolHead), F.CInfinity)), F.E), F.Set(F.Limit(F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.$p(F.x), F.CN1))), F.$p(F.x)), F.Rule(F.$p(F.x, (IExpr)F.SymbolHead), F.CInfinity)), F.Power((IExpr)F.E, F.CN1)));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IExpr lHospitalesRule(IExpr numerator, IExpr denominator, ISymbol sym, IExpr lim, IAST rule) {
        EvalEngine engine = EvalEngine.get();
        int limit = engine.getRecursionLimit();
        if (limit > 0) {
            IExpr expr = F.eval(F.Times((IExpr)F.D(numerator, sym), (IExpr)F.Power((IExpr)F.D(denominator, sym), F.CN1)));
            return Limit.limit(expr, sym, lim, rule, false);
        }
        try {
            if (limit <= 0) {
                engine.setRecursionLimit(128);
            }
            IExpr expr = F.eval(F.Times((IExpr)F.D(numerator, sym), (IExpr)F.Power((IExpr)F.D(denominator, sym), F.CN1)));
            IExpr iExpr = Limit.limit(expr, sym, lim, rule, false);
            return iExpr;
        }
        catch (RecursionLimitExceeded rle) {
            engine.setRecursionLimit(limit);
        }
        finally {
            engine.setRecursionLimit(limit);
        }
        return null;
    }

    public static IExpr limit(IExpr expr, ISymbol sym, IExpr lim, IAST rule, boolean evalExpr) {
        IExpr expression = expr;
        if (evalExpr) {
            IExpr result = F.eval(expression);
            if (result.isNumericFunction()) {
                return result;
            }
            if (!result.equals(F.Indeterminate)) {
                expression = result;
            }
            if (lim.isNumericFunction() && (result = expression.replaceAll(rule)) != null && (result = F.eval(result)).isNumericFunction()) {
                return result;
            }
        }
        if (expression.isFree(sym, true)) {
            return expression;
        }
        if (expression.equals(sym)) {
            return lim;
        }
        if (expression.isAST()) {
            IAST arg1 = (IAST)expression;
            IExpr header = arg1.head();
            if (arg1.size() == 2 && (header.equals(F.Sin) || header.equals(F.Cos))) {
                return F.$(header, F.Limit(arg1.arg1(), rule));
            }
            if (header == F.Plus) {
                return Limit.mapLimit(arg1, rule);
            }
            if (header == F.Times) {
                IAST plusResult;
                IExpr[] parts = Apart.getFractionalPartsTimes(arg1, false);
                if (parts != null && (plusResult = Apart.partialFractionDecompositionRational(new PartialFractionGenerator(), parts, sym)) != null && plusResult.size() > 2) {
                    return Limit.mapLimit(plusResult, rule);
                }
                IExpr numerator = parts[0];
                IExpr denominator = parts[1];
                IExpr temp = Limit.timesLimit(numerator, denominator, sym, lim, rule);
                if (temp != null) {
                    return temp;
                }
                return Limit.mapLimit(arg1, rule);
            }
            if (arg1.isAST(F.Power, 3) && ((IExpr)arg1.get(2)).isInteger()) {
                IInteger n = (IInteger)arg1.get(2);
                IExpr temp = F.eval(F.Limit(arg1.arg1(), rule));
                if (temp.isInfinity()) {
                    if (n.isPositive()) {
                        return temp;
                    }
                    if (n.isNegative()) {
                        return F.C0;
                    }
                    return null;
                }
                if (temp.isNegativeInfinity()) {
                    if (n.isPositive()) {
                        if (n.isEven()) {
                            return F.CInfinity;
                        }
                        return F.CNInfinity;
                    }
                    if (n.isNegative()) {
                        return F.C0;
                    }
                    return null;
                }
                if (temp.equals(F.Indeterminate) || temp.isAST(F.Limit)) {
                    return null;
                }
                if (n.isPositive()) {
                    return F.Power(temp, n);
                }
                if (n.isNegative() && n.isEven()) {
                    return F.Power(temp, n);
                }
            }
        }
        return null;
    }

    private static IExpr mapLimit(IAST expr, IAST rule) {
        IAST resultList = expr.clone();
        for (int i = 1; i < resultList.size(); ++i) {
            resultList.set(i, F.Limit((IExpr)resultList.get(i), rule));
        }
        return resultList;
    }

    private static IExpr timesLimit(IExpr numerator, IExpr denominator, ISymbol sym, IExpr lim, IAST rule) {
        if (denominator.isOne() && numerator.isTimes()) {
            return Limit.mapLimit((IAST)numerator, rule);
        }
        if (!denominator.isNumber() || denominator.isZero()) {
            IExpr denValue = F.evalBlock(denominator, sym, lim);
            if (denValue.equals(F.Indeterminate)) {
                return null;
            }
            if (denValue.isZero()) {
                IExpr numValue = F.evalBlock(numerator, sym, lim);
                if (numValue.isZero()) {
                    return Limit.lHospitalesRule(numerator, denominator, sym, lim, rule);
                }
                return null;
            }
            if (F.CInfinity.equals(denValue)) {
                IExpr numValue = F.evalBlock(numerator, sym, lim);
                if (F.CInfinity.equals(numValue)) {
                    return Limit.lHospitalesRule(numerator, denominator, sym, lim, rule);
                }
                return null;
            }
            if (denValue.isNegativeInfinity()) {
                IExpr numValue = F.evalBlock(numerator, sym, lim);
                if (numValue.isNegativeInfinity()) {
                    return Limit.lHospitalesRule(numerator, denominator, sym, lim, rule);
                }
                return null;
            }
        }
        return F.Times((IExpr)F.Limit(numerator, rule), (IExpr)F.Power((IExpr)F.Limit(denominator, rule), F.CN1));
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        if (!ast.arg2().isRuleAST()) {
            return null;
        }
        IAST rule = (IAST)ast.arg2();
        if (!rule.arg1().isSymbol()) {
            return null;
        }
        ISymbol sym = (ISymbol)rule.arg1();
        IExpr lim = null;
        if (!rule.arg2().isFree(sym, true)) {
            return null;
        }
        lim = (IExpr)rule.get(2);
        return Limit.limit(ast.arg1(), sym, lim, rule, true);
    }

    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(32);
        super.setUp(symbol);
    }
}

