/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.visit.VisitorLevelSpecification;

public class Level
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 5);
        int lastIndex = ast.size() - 1;
        boolean heads = false;
        Options options = new Options(ast.topHead(), ast, lastIndex);
        IExpr option = options.getOption("Heads");
        if (option != null) {
            --lastIndex;
            if (option.isTrue()) {
                heads = true;
            }
        } else {
            Validate.checkRange(ast, 3, 4);
        }
        if (!ast.arg1().isAtom()) {
            IAST arg1 = (IAST)ast.arg1();
            IAST resultList = lastIndex != 3 ? F.List() : F.ast((IExpr)ast.get(lastIndex));
            VisitorLevelSpecification level = new VisitorLevelSpecification(Functors.collect(resultList), (IExpr)ast.get(2), heads);
            arg1.accept(level);
            return resultList;
        }
        return null;
    }
}

