/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.special.Erf;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class InverseErf
extends AbstractTrigArg1
implements INumeric {
    @Override
    public IExpr numericEvalD1(Num arg1) {
        try {
            return Num.valueOf(Erf.erfInv((double)arg1.getRealPart()));
        }
        catch (MaxCountExceededException maxCountExceededException) {
            return null;
        }
    }

    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        if (arg1.isZero()) {
            return F.C0;
        }
        if (arg1.isOne()) {
            return F.CInfinity;
        }
        if (arg1.isMinusOne()) {
            return F.CNInfinity;
        }
        if (AbstractFunctionEvaluator.isNegativeExpression(arg1)) {
            return F.Times((IExpr)F.CN1, (IExpr)F.InverseErf(F.Times((IExpr)F.CN1, arg1)));
        }
        return null;
    }

    @Override
    public IExpr numericEvalDC1(ComplexNum arg1) {
        return null;
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        try {
            return Erf.erfInv((double)stack[top]);
        }
        catch (MaxCountExceededException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

