/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.IIndexFunction;
import org.matheclipse.core.eval.util.IndexTableGenerator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class HilbertMatrix
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        int rowSize = 0;
        int columnSize = 0;
        if (ast.size() == 2 && ast.arg1().isInteger()) {
            columnSize = rowSize = Validate.checkIntType(ast, 1);
        } else if (ast.size() == 3 && ast.arg1().isInteger() && ast.arg2().isInteger()) {
            rowSize = Validate.checkIntType(ast, 1);
            columnSize = Validate.checkIntType(ast, 2);
        } else {
            return null;
        }
        IAST resultList = F.List();
        int[] indexArray = new int[]{rowSize, columnSize};
        IndexTableGenerator generator = new IndexTableGenerator(indexArray, resultList, new HilbertFunctionDiagonal());
        IAST matrix = (IAST)generator.table();
        if (matrix != null) {
            matrix.addEvalFlags(32);
        }
        return matrix;
    }

    public class HilbertFunctionDiagonal
    implements IIndexFunction<IExpr> {
        @Override
        public IExpr evaluate(int[] index) {
            int res = index[0] + index[1] + 1;
            return F.Power((IExpr)F.integer(res), F.CN1);
        }
    }
}

