/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class FromCharacterCode
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 2) {
            return null;
        }
        if (ast.arg1().isList()) {
            IAST list = (IAST)ast.arg1();
            StringBuffer buffer = new StringBuffer();
            for (int i = 1; i < list.size(); ++i) {
                if (!((IExpr)list.get(i)).isInteger()) {
                    return null;
                }
                char ch = (char)Validate.checkIntType(list, i);
                buffer.append(ch);
            }
            return StringX.valueOf(buffer);
        }
        if (ast.arg1().isInteger()) {
            char ch = (char)Validate.checkIntType(ast, 1);
            return StringX.valueOf(ch);
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
    }

    public static List<IExpr> fromCharcterCode(String unicodeInput, String inputEncoding, List<IExpr> list) {
        try {
            String utf8String = new String(unicodeInput.getBytes(inputEncoding), "UTF-8");
            for (int i = 0; i < utf8String.length(); ++i) {
                char characterCode = utf8String.charAt(i);
                list.add(F.integer(characterCode));
            }
            return list;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

