/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.INum;

public class FractionalPart
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr expr = ast.arg1();
        if (expr.isSignedNumber()) {
            if (expr.isInteger()) {
                return F.C0;
            }
            if (expr.isFraction()) {
                BigInteger den;
                IFraction fr = (IFraction)expr;
                BigInteger num = fr.getBigNumerator();
                BigInteger div = num.divide(den = fr.getBigDenominator());
                if (div.equals(BigInteger.ZERO)) {
                    return F.C0;
                }
                return F.fraction(div, den);
            }
            if (expr instanceof INum) {
                // empty if block
            }
        }
        return null;
    }
}

