/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.math.BigIntegerMath;
import java.math.BigInteger;
import org.apache.commons.math3.special.Gamma;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class Factorial
extends AbstractTrigArg1 {
    @Override
    public IExpr numericEvalD1(Num arg1) {
        double d = Gamma.logGamma((double)(arg1.doubleValue() + 1.0));
        return F.num(Math.exp(d));
    }

    @Override
    public IExpr numericEvalDC1(ComplexNum arg1) {
        return null;
    }

    public static BigInteger factorial(BigInteger biggi) {
        try {
            BigInteger result;
            int ni = NumberUtil.toInt(biggi);
            if (ni < 0) {
                result = BigIntegerMath.factorial((int)(-1 * ni));
                if ((ni & 1) == 1) {
                    result = result.multiply(BigInteger.valueOf(-1L));
                }
            } else {
                result = BigIntegerMath.factorial((int)ni);
            }
            return result;
        }
        catch (ArithmeticException ae) {
            BigInteger result = BigInteger.ONE;
            if (biggi.compareTo(BigInteger.ZERO) == -1) {
                result = BigInteger.valueOf(-1L);
                BigInteger i = BigInteger.valueOf(-2L);
                while (i.compareTo(biggi) >= 0) {
                    result = result.multiply(i);
                    i = i.add(BigInteger.valueOf(-1L));
                }
            } else {
                BigInteger i = BigInteger.valueOf(2L);
                while (i.compareTo(biggi) <= 0) {
                    result = result.multiply(i);
                    i = i.add(BigInteger.ONE);
                }
            }
            return result;
        }
    }

    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        if (arg1.isInteger()) {
            BigInteger fac = Factorial.factorial(((IInteger)arg1).getBigNumerator());
            return F.integer(fac);
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

