/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Apart;

public class Denominator
implements IFunctionEvaluator {
    static ISymbol[] NUMERATOR_SYMBOLS = new ISymbol[]{F.Csc, F.Cot, F.Sec};
    static ISymbol[] DENOMINATOR_SYMBOLS = new ISymbol[]{F.Sin, F.Tan, F.Cos};

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr expr = ast.arg1();
        if (expr.isRational()) {
            return ((IRational)expr).getDenominator();
        }
        IExpr[] parts = Apart.getFractionalParts(expr);
        return parts[1];
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }

    public static IAST getDenominatorForm(IAST function) {
        if (function.size() == 2) {
            for (int i = 0; i < NUMERATOR_SYMBOLS.length; ++i) {
                ISymbol sym = NUMERATOR_SYMBOLS[i];
                if (!function.head().equals(sym)) continue;
                return F.$(DENOMINATOR_SYMBOLS[i], function.arg1());
            }
        }
        return null;
    }
}

