/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractArg1;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Decrement
extends AbstractArg1 {
    @Override
    public IExpr e1ObjArg(IExpr o0) {
        ISymbol sym = Validate.checkAssignedVariable(o0);
        IExpr[] results = sym.reassignSymbolValue(this.getFunction(), this.getFunctionSymbol());
        if (results != null) {
            return this.getResult(results[0], results[1]);
        }
        return null;
    }

    protected Function<IExpr, IExpr> getFunction() {
        return new DecrementFunction();
    }

    protected ISymbol getFunctionSymbol() {
        return F.Decrement;
    }

    protected IExpr getResult(IExpr symbolValue, IExpr calculatedResult) {
        return symbolValue;
    }

    protected IExpr apply(IExpr assignedValue) {
        return F.eval(F.Plus(assignedValue, (IExpr)F.CN1));
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }

    class DecrementFunction
    implements Function<IExpr, IExpr> {
        DecrementFunction() {
        }

        public IExpr apply(IExpr assignedValue) {
            return F.eval(F.Plus(assignedValue, (IExpr)F.CN1));
        }
    }
}

