/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.VisitorLevelSpecification;

public class Count
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        CountFunctor mf = new CountFunctor((IExpr)ast.get(2));
        VisitorLevelSpecification level = ast.size() == 4 ? new VisitorLevelSpecification((Function<IExpr, IExpr>)mf, (IExpr)ast.get(3), false) : new VisitorLevelSpecification(mf, 1);
        ast.arg1().accept(level);
        return F.integer(mf.getCounter());
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(64);
    }

    private static class CountFunctor
    implements Function<IExpr, IExpr> {
        protected final IPatternMatcher matcher;
        protected int counter;

        public int getCounter() {
            return this.counter;
        }

        public CountFunctor(IExpr pattern) {
            this.matcher = new PatternMatcher(pattern);
            this.counter = 0;
        }

        public IExpr apply(IExpr arg) {
            if (this.matcher.apply(arg)) {
                ++this.counter;
            }
            return null;
        }
    }
}

