/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class Collect
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        try {
            if (!((IExpr)ast.get(2)).isList()) {
                IExpr arg1 = F.evalExpandAll(ast.arg1());
                IExpr arg2 = ast.arg2();
                return this.collectSingleVariable(arg1, arg2, F.List(), 1);
            }
            IExpr arg1 = F.evalExpandAll(ast.arg1());
            IAST list = (IAST)ast.get(2);
            if (list.size() > 1) {
                return this.collectSingleVariable(arg1, list.arg1(), (IAST)ast.arg2(), 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public IExpr collectSingleVariable(IExpr arg1, IExpr arg2, IAST list, int pos) {
        if (arg1.isAST()) {
            HashMap<IExpr, IAST> map = new HashMap<IExpr, IAST>();
            IAST poly = (IAST)arg1;
            IAST rest = F.Plus();
            PatternMatcher matcher = new PatternMatcher(arg2);
            this.collectToMap(poly, matcher, map, rest);
            if (pos < list.size()) {
                IAST result = F.Plus();
                if (rest.size() > 1) {
                    result.add(this.collectSingleVariable(rest, (IExpr)list.get(pos), list, pos + 1));
                }
                for (IExpr key : map.keySet()) {
                    IAST value = (IAST)map.get(key);
                    IExpr temp = this.collectSingleVariable(value.getOneIdentity(F.C0), (IExpr)list.get(pos), list, pos + 1);
                    result.add(F.Times(key, temp));
                }
                return result;
            }
            for (IExpr key : map.keySet()) {
                IAST value = (IAST)map.get(key);
                rest.add(F.Times(key).addOneIdentity(value));
            }
            return rest.getOneIdentity(F.C0);
        }
        return arg1;
    }

    public void collectToMap(IExpr expr, IPatternMatcher matcher, Map<IExpr, IAST> map, IAST rest) {
        if (expr.isFree(matcher, false)) {
            rest.add(expr);
            return;
        }
        if (matcher.apply(expr)) {
            this.addPowerFactor(expr, F.C1, map);
            return;
        }
        if (this.isPowerMatched(expr, matcher)) {
            this.addPowerFactor((IAST)expr, F.C1, map);
            return;
        }
        if (expr.isPlus()) {
            IAST plusAST = (IAST)expr;
            IAST clone = plusAST.clone();
            int i = 1;
            while (i < clone.size()) {
                if (this.collectToMapPlus((IExpr)clone.get(i), matcher, map)) {
                    clone.remove(i);
                    continue;
                }
                ++i;
            }
            if (clone.size() > 1) {
                rest.addOneIdentity(clone);
            }
            return;
        }
        if (expr.isTimes()) {
            IAST timesAST = (IAST)expr;
            for (int i = 1; i < timesAST.size(); ++i) {
                if (!matcher.apply((IExpr)timesAST.get(i)) && !this.isPowerMatched((IExpr)timesAST.get(i), matcher)) continue;
                IAST clone = timesAST.clone();
                clone.remove(i);
                this.addOneIdentityPowerFactor((IExpr)timesAST.get(i), clone, map);
                return;
            }
            rest.add(expr);
            return;
        }
        rest.add(expr);
    }

    public boolean collectToMapPlus(IExpr expr, IPatternMatcher matcher, Map<IExpr, IAST> map) {
        if (expr.isFree(matcher, false)) {
            return false;
        }
        if (matcher.apply(expr)) {
            this.addPowerFactor(expr, F.C1, map);
            return true;
        }
        if (this.isPowerMatched(expr, matcher)) {
            this.addPowerFactor(expr, F.C1, map);
            return true;
        }
        if (expr.isTimes()) {
            IAST timesAST = (IAST)expr;
            for (int i = 1; i < timesAST.size(); ++i) {
                if (!matcher.apply((IExpr)timesAST.get(i)) && !this.isPowerMatched((IExpr)timesAST.get(i), matcher)) continue;
                IAST clone = timesAST.clone();
                clone.remove(i);
                this.addOneIdentityPowerFactor((IExpr)timesAST.get(i), clone, map);
                return true;
            }
        }
        return false;
    }

    public void addOneIdentityPowerFactor(IExpr key, IAST subAST, Map<IExpr, IAST> map) {
        IAST resultList = map.get(key);
        if (resultList == null) {
            resultList = F.Plus();
            map.put(key, resultList);
        }
        resultList.addOneIdentity(subAST);
    }

    public void addPowerFactor(IExpr key, IExpr value, Map<IExpr, IAST> map) {
        IAST resultList = map.get(key);
        if (resultList == null) {
            resultList = F.Plus();
            map.put(key, resultList);
        }
        resultList.add(value);
    }

    public boolean isPowerMatched(IExpr poly, IPatternMatcher matcher) {
        return poly.isPower() && ((IExpr)((IAST)poly).get(2)).isNumber() && matcher.apply(((IAST)poly).arg1());
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

