/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class Coefficient
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        IExpr expr = F.evalExpandAll(ast.arg1());
        IExpr arg2 = ast.arg2();
        if (!arg2.isSymbol()) {
            return null;
        }
        try {
            IInteger n = F.C1;
            if (ast.size() == 4) {
                n = Validate.checkIntegerType(ast, 3);
            }
            if (expr.isAST()) {
                IAST expAST = (IAST)expr;
                PlusFunction plusFunction = new PlusFunction(arg2, n);
                if (expAST.isPlus()) {
                    IAST filterAST = expAST.map(plusFunction);
                    if (filterAST.size() == 1) {
                        return F.C0;
                    }
                    return F.eval(filterAST);
                }
                return (IExpr)plusFunction.apply(expAST);
            }
            return Coefficient.coefficientAtom(expr, arg2, n);
        }
        catch (ArithmeticException ae) {
            return null;
        }
    }

    private static IExpr coefficientTimes(IAST times, IExpr arg2, IInteger n) throws ArithmeticException {
        for (int i = 1; i < times.size(); ++i) {
            if (((IExpr)times.get(i)).isPower()) {
                IAST pow = (IAST)times.get(i);
                if (!pow.arg1().equals(arg2)) continue;
                if (pow.arg2().isNumEqualInteger(n)) {
                    times = times.clone();
                    times.remove(i);
                    return times;
                }
                return F.C0;
            }
            if (!((IExpr)times.get(i)).equals(arg2)) continue;
            if (n.equals(F.C0)) {
                return F.C0;
            }
            if (n.equals(F.C1)) {
                times = times.clone();
                times.remove(i);
                return times;
            }
            return F.C0;
        }
        if (n.equals(F.C0)) {
            return times;
        }
        return F.C0;
    }

    private static IExpr coefficientPower(IAST powerAST, IExpr arg2, IInteger n) {
        if (powerAST.arg1().equals(arg2)) {
            if (powerAST.arg2().isNumEqualInteger(n)) {
                return F.C1;
            }
            return F.C0;
        }
        return powerAST;
    }

    private static IExpr coefficientAtom(IExpr expr, IExpr arg2, IInteger n) {
        if (n.equals(F.C0)) {
            if (expr.equals(arg2)) {
                return F.C0;
            }
            return expr;
        }
        if (n.equals(F.C1)) {
            if (expr.equals(arg2)) {
                return F.C1;
            }
            return F.C0;
        }
        return F.C0;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }

    private class PlusFunction
    implements Function<IExpr, IExpr> {
        IExpr arg2;
        IInteger n;

        public PlusFunction(IExpr arg2, IInteger n) {
            this.arg2 = arg2;
            this.n = n;
        }

        public IExpr apply(IExpr from) throws ArithmeticException {
            if (from.isPower()) {
                return Coefficient.coefficientPower((IAST)from, this.arg2, this.n);
            }
            if (from.isTimes()) {
                return Coefficient.coefficientTimes((IAST)from, this.arg2, this.n);
            }
            return Coefficient.coefficientAtom(from, this.arg2, this.n);
        }
    }
}

