/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.math.BigIntegerMath;
import java.math.BigInteger;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class Binomial
extends AbstractArg2 {
    @Override
    public IExpr e2IntArg(IInteger n0, IInteger k0) {
        BigInteger n = n0.getBigNumerator();
        BigInteger k = k0.getBigNumerator();
        return F.integer(Binomial.binomial(n, k));
    }

    public static BigInteger binomial(int n, int k) {
        return BigIntegerMath.binomial((int)n, (int)k);
    }

    public static BigInteger binomial(BigInteger n, BigInteger k) {
        if (k.compareTo(n) > 0) {
            return BigInteger.ZERO;
        }
        if (k.equals(BigInteger.ZERO) || k.equals(n)) {
            return BigInteger.ONE;
        }
        try {
            int ni = NumberUtil.toInt(n);
            int ki = NumberUtil.toInt(k);
            if (ki > ni) {
                return BigInteger.ZERO;
            }
            return BigIntegerMath.binomial((int)ni, (int)ki);
        }
        catch (ArithmeticException ae) {
            BigInteger bin = BigInteger.ONE;
            BigInteger i = BigInteger.ONE;
            while (i.compareTo(k) <= 0) {
                bin = bin.multiply(n.subtract(i).add(BigInteger.ONE)).divide(i);
                i = i.add(BigInteger.ONE);
            }
            return bin;
        }
    }
}

