/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class And
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        int i;
        Validate.checkRange(ast, 3);
        boolean evaled = false;
        EvalEngine engine = EvalEngine.get();
        IAST result = ast.clone();
        int index = 1;
        int[] symbols = new int[ast.size()];
        int[] notSymbols = new int[ast.size()];
        for (i = 1; i < ast.size(); ++i) {
            IExpr sym;
            IExpr temp = engine.evaluateNull((IExpr)ast.get(i));
            if (temp == null) {
                temp = (IExpr)ast.get(i);
            } else {
                result.set(index, temp);
                evaled = true;
            }
            if (temp.isFalse()) {
                return F.False;
            }
            if (temp.isTrue()) {
                result.remove(index);
                evaled = true;
                continue;
            }
            if (temp.isSymbol()) {
                symbols[i] = ((IExpr)ast.get(i)).hashCode();
            } else if (temp.isNot() && (sym = ((IAST)temp).getAt(1)).isSymbol()) {
                notSymbols[i] = sym.hashCode();
            }
            ++index;
        }
        for (i = 1; i < symbols.length; ++i) {
            if (symbols[i] == 0) continue;
            for (int j = 1; j < notSymbols.length; ++j) {
                if (i == j || symbols[i] != notSymbols[j] || !((IExpr)result.get(i)).equals(((IExpr)result.get(j)).getAt(1))) continue;
                return F.False;
            }
        }
        if (evaled) {
            if (result.size() == 1) {
                return F.True;
            }
            return result;
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(105);
    }
}

