/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import java.math.BigInteger;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.polynomials.IPartialFractionGenerator;

public class PartialFractionGenerator
implements IPartialFractionGenerator {
    IAST result = F.Plus();
    JASConvert<BigRational> jas;

    @Override
    public void setJAS(JASConvert<BigRational> jas) {
        this.jas = jas;
    }

    @Override
    public IAST getResult() {
        return this.result;
    }

    @Override
    public void addNonFractionalPart(GenPolynomial<BigRational> genPolynomial) {
        IExpr temp = F.eval(this.jas.poly2Expr(genPolynomial, null));
        if (temp.isAST()) {
            ((IAST)temp).addEvalFlags(128);
        }
        this.result.add(temp);
    }

    @Override
    public void addSinglePartialFraction(GenPolynomial<BigRational> genPolynomial, GenPolynomial<BigRational> Di_1, int j) {
        Object[] objects = this.jas.factorTerms(genPolynomial);
        BigInteger gcd = (BigInteger)objects[0];
        BigInteger lcm = (BigInteger)objects[1];
        GenPolynomial poly = (GenPolynomial)objects[2];
        IExpr temp = j == 1 ? F.eval(F.Times(F.integer(gcd), this.jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)poly), F.Power((IExpr)this.jas.poly2Expr((GenPolynomial<BigRational>)Di_1.multiply((RingElem)BigRational.valueOf((BigInteger)lcm)), null), F.CN1))) : F.eval(F.Times(F.integer(gcd), this.jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)poly), F.Power((IExpr)F.integer(lcm), F.integer(-1L)), F.Power((IExpr)this.jas.poly2Expr(Di_1, null), F.integer((long)j * -1L))));
        if (!temp.isZero()) {
            if (temp.isAST()) {
                ((IAST)temp).addEvalFlags(128);
            }
            this.result.add(temp);
        }
    }
}

