/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;

public class PatternMap
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5384429232269800438L;
    private int fPatternCounter = 0;
    private boolean fRuleWithoutPattern = true;
    private ISymbol[] fSymbolsArray;
    private IExpr[] fPatternValuesArray;

    public PatternMap() {
        this(new IExpr[0]);
    }

    private PatternMap(IExpr[] exprArray) {
        this.fPatternValuesArray = exprArray;
    }

    protected void addPattern(TreeMap<ISymbol, Integer> patternIndexMap, IPatternObject pattern) {
        this.fRuleWithoutPattern = false;
        ISymbol sym = pattern.getSymbol();
        if (sym != null) {
            Integer i = patternIndexMap.get(sym);
            if (i != null) {
                pattern.setIndex(i);
                return;
            }
            pattern.setIndex(this.fPatternCounter);
            patternIndexMap.put(sym, this.fPatternCounter++);
        }
    }

    protected void addSinglePattern(IPatternObject pattern) {
        this.fRuleWithoutPattern = false;
        ISymbol sym = pattern.getSymbol();
        if (sym != null) {
            pattern.setIndex(0);
            this.fSymbolsArray = new ISymbol[1];
            this.fPatternValuesArray = new IExpr[1];
            this.fSymbolsArray[0] = sym;
            ++this.fPatternCounter;
        }
    }

    protected void determinePatterns(IExpr lhsPatternExpr) {
        if (lhsPatternExpr instanceof IAST) {
            TreeMap<ISymbol, Integer> patternIndexMap = new TreeMap<ISymbol, Integer>();
            this.determinePatternsRecursive(patternIndexMap, (IAST)lhsPatternExpr);
            this.fSymbolsArray = new ISymbol[this.fPatternCounter];
            this.fPatternValuesArray = new IExpr[this.fPatternCounter];
            for (ISymbol sym : patternIndexMap.keySet()) {
                Integer indx = patternIndexMap.get(sym);
                this.fSymbolsArray[indx.intValue()] = sym;
            }
        } else if (lhsPatternExpr instanceof IPatternObject) {
            this.addSinglePattern((IPatternObject)((Object)lhsPatternExpr));
        }
    }

    private int determinePatternsRecursive(TreeMap<ISymbol, Integer> patternIndexMap, IAST lhsPatternExpr) {
        IAST ast = lhsPatternExpr;
        int listEvalFlags = 0;
        for (int i = 0; i < ast.size(); ++i) {
            IExpr temp = (IExpr)ast.get(i);
            if (temp.isAST()) {
                listEvalFlags |= this.determinePatternsRecursive(patternIndexMap, (IAST)temp);
                continue;
            }
            if (!(temp instanceof IPatternObject)) continue;
            if (temp.isPattern()) {
                IPattern pat = (IPattern)temp;
                this.addPattern(patternIndexMap, pat);
                if (pat.isDefault()) {
                    listEvalFlags |= 4;
                    continue;
                }
                listEvalFlags |= 1;
                continue;
            }
            if (!temp.isPatternSequence()) continue;
            this.addPattern(patternIndexMap, (IPatternSequence)temp);
            listEvalFlags |= 2;
        }
        ast.setEvalFlags(listEvalFlags);
        return listEvalFlags &= 0xFFFB;
    }

    protected PatternMap clone() {
        PatternMap result = new PatternMap(null);
        result.fPatternValuesArray = new IExpr[this.fPatternValuesArray.length];
        System.arraycopy(this.fPatternValuesArray, 0, result.fPatternValuesArray, 0, this.fPatternValuesArray.length);
        result.fSymbolsArray = this.fSymbolsArray;
        result.fPatternCounter = this.fPatternCounter;
        result.fRuleWithoutPattern = this.fRuleWithoutPattern;
        return result;
    }

    public IExpr[] copyPattern() {
        IExpr[] patternValuesArray = new IExpr[this.fPatternValuesArray.length];
        System.arraycopy(this.fPatternValuesArray, 0, patternValuesArray, 0, this.fPatternValuesArray.length);
        return patternValuesArray;
    }

    public void copyPatternValuesFromPatternMatcher(PatternMap patternMap) {
        ISymbol[] symbolsArray = patternMap.fSymbolsArray;
        for (int i = 0; i < symbolsArray.length; ++i) {
            for (int j = 0; j < this.fSymbolsArray.length; ++j) {
                if (this.fSymbolsArray[j] != symbolsArray[i]) continue;
                this.fPatternValuesArray[j] = patternMap.fPatternValuesArray[i];
            }
        }
    }

    private Map<ISymbol, IExpr> getRulesMap() {
        IdentityHashMap<ISymbol, IExpr> rulesMap = new IdentityHashMap<ISymbol, IExpr>(this.fSymbolsArray.length * 2);
        for (int i = 0; i < this.fSymbolsArray.length; ++i) {
            if (this.fPatternValuesArray[i] == null) continue;
            rulesMap.put(this.fSymbolsArray[i], this.fPatternValuesArray[i]);
        }
        return rulesMap;
    }

    public IExpr getValue(IPatternObject pattern) {
        int indx = pattern.getIndex();
        if (indx >= 0) {
            return this.fPatternValuesArray[indx];
        }
        return null;
    }

    public List<IExpr> getValuesAsList() {
        ArrayList<IExpr> args = new ArrayList<IExpr>(this.fPatternValuesArray.length);
        for (int i = 0; i < this.fPatternValuesArray.length; ++i) {
            IExpr arg = this.fPatternValuesArray[i];
            if (arg == null) {
                return null;
            }
            args.add(arg);
        }
        return args;
    }

    protected void initPattern() {
        Arrays.fill(this.fPatternValuesArray, null);
    }

    public boolean isAllPatternsAssigned() {
        if (this.fPatternValuesArray != null) {
            for (int i = 0; i < this.fPatternValuesArray.length; ++i) {
                if (this.fPatternValuesArray[i] != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRuleWithoutPatterns() {
        return this.fRuleWithoutPattern;
    }

    public void resetPattern(IExpr[] patternValuesArray) {
        System.arraycopy(patternValuesArray, 0, this.fPatternValuesArray, 0, this.fPatternValuesArray.length);
    }

    public void setValue(IPatternObject pattern, IExpr expr) {
        int indx = pattern.getIndex();
        if (indx >= 0) {
            this.fPatternValuesArray[indx] = expr;
        }
    }

    public int size() {
        return this.fPatternValuesArray.length;
    }

    public IExpr substitutePatternSymbols(IExpr expression) {
        if (this.fPatternValuesArray != null) {
            return F.subst(expression, Functors.rules(this.getRulesMap()));
        }
        return expression;
    }
}

