/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import org.matheclipse.combinatoric.AbstractListStepVisitor;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMap;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class FlatStepVisitor
extends AbstractListStepVisitor<IExpr> {
    protected ISymbol fSymbol;
    protected PatternMatcher.StackMatcher stackMatcher;
    protected PatternMap fPatternMap;
    protected IExpr[] patternValues;
    protected IAST fLhsPatternAST;
    protected boolean fOneIdentity;

    public FlatStepVisitor(ISymbol sym, IAST lhsPatternAST, IAST lhsEvalAST, PatternMatcher.StackMatcher stackMatcher, PatternMap patternMap) {
        super(lhsEvalAST, 1, lhsEvalAST.size());
        this.fSymbol = sym;
        this.stackMatcher = stackMatcher;
        this.fPatternMap = patternMap;
        this.patternValues = patternMap.copyPattern();
        this.fLhsPatternAST = lhsPatternAST;
        this.fOneIdentity = (sym.getAttributes() & 1) == 1;
    }

    @Override
    public boolean visit(int[][] result) {
        if (this.matchSinglePartition(result, this.stackMatcher)) {
            return false;
        }
        this.fPatternMap.resetPattern(this.patternValues);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchSinglePartition(int[][] result, PatternMatcher.StackMatcher stackMatcher) {
        int lastStackSize = stackMatcher.size();
        boolean matched = true;
        try {
            boolean bl;
            for (int j = 0; j < result.length; ++j) {
                boolean bl2;
                int n = result[j].length;
                if (n == 1 && this.fOneIdentity) {
                    if (stackMatcher.push((IExpr)this.fLhsPatternAST.get(j + 1), (IExpr)this.array[result[j][0]])) continue;
                    matched = false;
                    bl2 = false;
                    return bl2;
                }
                IAST partitionElement = F.ast(this.fSymbol, n, false);
                for (int i = 0; i < n; ++i) {
                    partitionElement.add((IExpr)this.array[result[j][i]]);
                }
                if (stackMatcher.push((IExpr)this.fLhsPatternAST.get(j + 1), partitionElement)) continue;
                matched = false;
                bl2 = false;
                return bl2;
            }
            if (!stackMatcher.matchRest()) {
                matched = false;
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            if (!matched) {
                stackMatcher.removeFrom(lastStackSize);
            }
        }
    }
}

