/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic.combinatoric;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

class CartesianProductIterator
implements Iterator<IAST> {
    final List<IAST> comps;
    final List<Iterator<IExpr>> compit;
    IAST current;
    boolean empty;

    public CartesianProductIterator(List<IAST> comps, IAST emptyResultList) {
        if (comps == null) {
            throw new IllegalArgumentException("null comps not allowed");
        }
        this.comps = comps;
        this.current = emptyResultList;
        this.compit = new ArrayList<Iterator<IExpr>>(comps.size());
        this.empty = false;
        for (IAST ci : comps) {
            Iterator<IExpr> it = ci.iterator();
            if (!it.hasNext()) {
                this.empty = true;
                this.current.clear();
                break;
            }
            this.current.add(it.next());
            this.compit.add(it);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.empty;
    }

    @Override
    public synchronized IAST next() {
        Iterator<IExpr> iter;
        int j;
        Iterator<IExpr> iter2;
        int i;
        if (this.empty) {
            throw new RuntimeException("invalid call of next()");
        }
        IAST res = this.current.clone();
        for (i = this.compit.size() - 1; i >= 0 && !(iter2 = this.compit.get(i)).hasNext(); --i) {
        }
        if (i < 0) {
            this.empty = true;
            return res;
        }
        for (j = i + 1; j < this.compit.size(); ++j) {
            iter = this.comps.get(j).iterator();
            this.compit.set(j, iter);
        }
        for (j = i; j < this.compit.size(); ++j) {
            iter = this.compit.get(j);
            IExpr el = iter.next();
            this.current.set(j + 1, el);
        }
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove tuples");
    }
}

