/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.tex.reflection;

import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.form.tex.AbstractOperator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class Times
extends AbstractOperator {
    public static final int NO_SPECIAL_CALL = 0;
    public static final int PLUS_CALL = 1;

    public Times() {
        super(ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getPrecedence(), "\\,");
    }

    @Override
    public boolean convert(StringBuffer buf, IAST f, int precedence) {
        return this.convert(buf, f, precedence, 0);
    }

    public boolean convert(StringBuffer buf, IAST f, int precedence, int caller) {
        IAST numerator = F.Times();
        IAST denominator = F.Times();
        for (int i = 1; i < f.size(); ++i) {
            IAST p;
            if (((IExpr)f.get(i)).isAST() && ((IAST)f.get(i)).head().toString().equals(AST2Expr.POWER_STRING) && (p = (IAST)f.get(i)).size() == 3 && p.get(2) instanceof ISignedNumber && ((ISignedNumber)p.get(2)).isNegative()) {
                if (NumberUtil.isMinusOne((IExpr)p.get(2))) {
                    denominator.add(p.get(1));
                    continue;
                }
                denominator.add(F.Power((IExpr)p.get(1), F.Times((IExpr)F.CN1, (IExpr)p.get(2))));
                continue;
            }
            if (NumberUtil.isOne((IExpr)f.get(i))) continue;
            numerator.add(f.get(i));
        }
        if (denominator.size() > 1) {
            if (caller == 1) {
                buf.append('+');
            }
            buf.append("\\frac{");
            if (numerator.size() != 1) {
                if (numerator.size() == 2) {
                    this.fFactory.convert(buf, numerator.get(1), 0);
                } else {
                    this.fFactory.convert(buf, numerator, this.fPrecedence);
                }
            } else {
                buf.append('1');
            }
            buf.append("}{");
            if (denominator.size() == 2) {
                this.fFactory.convert(buf, denominator.get(1), 0);
            } else {
                this.fFactory.convert(buf, denominator, this.fPrecedence);
            }
            buf.append('}');
        } else if (numerator.size() <= 2) {
            this.convertMultiply(buf, f, precedence, caller);
        } else {
            this.convertMultiply(buf, numerator, precedence, caller);
        }
        return true;
    }

    private boolean convertMultiply(StringBuffer buf, IAST f, int precedence, int caller) {
        if (f.size() > 1) {
            IExpr expr = (IExpr)f.get(1);
            if (NumberUtil.isMinusOne(expr)) {
                if (f.size() == 2) {
                    this.precedenceOpen(buf, precedence);
                    this.fFactory.convert(buf, expr, this.fPrecedence);
                } else if (caller == 1) {
                    buf.append(" - ");
                    if (f.size() == 3) {
                        this.fFactory.convert(buf, f.get(2), this.fPrecedence);
                        return true;
                    }
                } else {
                    this.precedenceOpen(buf, precedence);
                    buf.append(" - ");
                }
            } else {
                if (caller == 1) {
                    if (expr.isSignedNumber() && ((ISignedNumber)expr).isNegative()) {
                        buf.append(" - ");
                        expr = ((ISignedNumber)expr).negate();
                    } else {
                        buf.append(" + ");
                    }
                } else {
                    this.precedenceOpen(buf, precedence);
                }
                this.fFactory.convert(buf, expr, this.fPrecedence);
                if (this.fOperator.compareTo("") != 0) {
                    buf.append("\\,");
                }
            }
        }
        for (int i = 2; i < f.size(); ++i) {
            this.fFactory.convert(buf, f.get(i), this.fPrecedence);
            if (i >= f.size() - 1 || this.fOperator.compareTo("") == 0) continue;
            buf.append("\\,");
        }
        this.precedenceClose(buf, precedence);
        return true;
    }
}

