/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

public class LevelSpec {
    protected int fFromLevel;
    protected int fToLevel;
    protected int fFromDepth;
    protected int fToDepth;
    protected boolean fIncludeHeads;
    protected int fCurrentLevel;
    protected int fCurrentDepth;

    public LevelSpec() {
        this(0);
    }

    public LevelSpec(int level) {
        this(level, true);
    }

    public LevelSpec(int level, boolean includeHeads) {
        this(level, level, includeHeads);
    }

    public LevelSpec(int fromLevel, int toLevel) {
        this(fromLevel, toLevel, true);
    }

    public LevelSpec(int fromLevel, int toLevel, boolean includeHeads) {
        this(fromLevel, toLevel, Integer.MIN_VALUE, -1, includeHeads);
    }

    public LevelSpec(int fromLevel, int toLevel, int fromDepth, int toDepth, boolean includeHeads) {
        this.fFromLevel = fromLevel;
        this.fToLevel = toLevel;
        this.fCurrentLevel = 0;
        this.fIncludeHeads = includeHeads;
        this.fFromDepth = fromDepth;
        this.fCurrentDepth = -1;
        this.fToDepth = toDepth;
    }

    public final int getCurrentLevel() {
        return this.fCurrentLevel;
    }

    public final void resetCurrentLevel() {
        this.fCurrentLevel = 0;
    }

    public final void setFromLevelAsCurrent() {
        this.fCurrentLevel = this.fFromLevel;
    }

    public final void setToLevelAsCurrent() {
        this.fCurrentLevel = this.fToLevel;
    }

    public final void decCurrentDepth() {
        --this.fCurrentDepth;
    }

    public final void incCurrentLevel() {
        ++this.fCurrentLevel;
    }

    public final void decCurrentLevel() {
        --this.fCurrentLevel;
    }

    public boolean isInRange() {
        return this.fCurrentLevel >= this.fFromLevel && this.fCurrentLevel <= this.fToLevel && this.fCurrentDepth >= this.fFromDepth && this.fCurrentDepth <= this.fToDepth;
    }

    public boolean isInScope() {
        return this.fCurrentLevel <= this.fToLevel && this.fCurrentDepth <= this.fToDepth;
    }

    public final int getCurrentDepth() {
        return this.fCurrentDepth;
    }

    public final void setCurrentDepth(int currentDepth) {
        this.fCurrentDepth = currentDepth;
    }

    public final void setCurrentLevel(int currentLevel) {
        this.fCurrentLevel = currentLevel;
    }

    public int getFromLevel() {
        return this.fFromLevel;
    }

    public int getToLevel() {
        return this.fToLevel;
    }

    public int getFromDepth() {
        return this.fFromDepth;
    }

    public int getToDepth() {
        return this.fToDepth;
    }

    public boolean isIncludeHeads() {
        return this.fIncludeHeads;
    }
}

