/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.HashedOrderlessMatcher;
import org.matheclipse.parser.client.SyntaxError;

public abstract class AbstractArgMultiple
extends AbstractArg2 {
    @Override
    public IExpr evaluate(IAST ast) {
        IAST temp;
        if (ast.size() > 2 && (temp = this.evaluateHashs(ast)) != null) {
            return temp;
        }
        if (ast.size() == 3) {
            return this.binaryOperator((IExpr)ast.get(1), (IExpr)ast.get(2));
        }
        if (ast.size() > 3) {
            ISymbol sym = ast.topHead();
            IAST result = F.ast(sym);
            IExpr temp2 = (IExpr)ast.get(1);
            boolean evaled = false;
            int i = 2;
            while (i < ast.size()) {
                IExpr tres = this.binaryOperator(temp2, (IExpr)ast.get(i));
                if (tres == null) {
                    for (int j = i + 1; j < ast.size(); ++j) {
                        tres = this.binaryOperator(temp2, (IExpr)ast.get(j));
                        if (tres == null) continue;
                        evaled = true;
                        temp2 = tres;
                        ast.remove(j);
                        break;
                    }
                    if (tres != null) continue;
                    result.add(temp2);
                    if (i == ast.size() - 1) {
                        result.add(ast.get(i));
                    } else {
                        temp2 = (IExpr)ast.get(i);
                    }
                    ++i;
                    continue;
                }
                evaled = true;
                temp2 = tres;
                if (i == ast.size() - 1) {
                    result.add(temp2);
                }
                ++i;
            }
            if (evaled) {
                if (result.size() == 2 && (sym.getAttributes() & 1) == 1) {
                    return (IExpr)result.get(1);
                }
                return result;
            }
        }
        return null;
    }

    public HashedOrderlessMatcher getHashRuleMap() {
        return null;
    }

    public IAST evaluateHashs(IAST ast) {
        HashedOrderlessMatcher hashRuleMap = this.getHashRuleMap();
        if (hashRuleMap == null) {
            return null;
        }
        return hashRuleMap.evaluate(ast);
    }

    public void setUpHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs, IExpr condition) {
        this.getHashRuleMap().setUpHashRule(lhs1, lhs2, rhs, condition);
    }

    public void setUpHashRule(String lhs1Str, String lhs2Str, String rhsStr, String conditionStr) throws SyntaxError {
        this.getHashRuleMap().setUpHashRule(lhs1Str, lhs2Str, rhsStr, conditionStr);
    }

    public void setUpHashRule(String lhs1Str, String lhs2Str, String rhsStr) throws SyntaxError {
        this.getHashRuleMap().setUpHashRule(lhs1Str, lhs2Str, rhsStr);
    }

    @Override
    public IExpr binaryOperator(IExpr o0, IExpr o1) {
        IExpr result = null;
        if (o0 instanceof INum) {
            if (o1 instanceof INum) {
                result = this.e2DblArg((INum)o0, (INum)o1);
            } else if (o1.isInteger()) {
                result = this.e2DblArg((INum)o0, F.num((IInteger)o1));
            } else if (o1.isFraction()) {
                result = this.e2DblArg((INum)o0, F.num((IFraction)o1));
            } else if (o1 instanceof IComplexNum) {
                result = this.e2DblComArg(F.complexNum(((INum)o0).getRealPart()), (IComplexNum)o1);
            }
            if (result != null) {
                return result;
            }
            return this.e2ObjArg(o0, o1);
        }
        if (o1 instanceof INum) {
            if (o0.isInteger()) {
                result = this.e2DblArg(F.num((IInteger)o0), (INum)o1);
            } else if (o0.isFraction()) {
                result = this.e2DblArg(F.num((IFraction)o0), (INum)o1);
            } else if (o0 instanceof IComplexNum) {
                result = this.e2DblComArg((IComplexNum)o0, F.complexNum(((INum)o1).getRealPart()));
            }
            if (result != null) {
                return result;
            }
            return this.e2ObjArg(o0, o1);
        }
        if (o0 instanceof IComplexNum) {
            if (o1 instanceof INum) {
                result = this.e2DblComArg((IComplexNum)o0, F.complexNum(((INum)o1).getRealPart()));
            } else if (o1.isInteger()) {
                result = this.e2DblComArg((IComplexNum)o0, F.complexNum((IInteger)o1));
            } else if (o1.isFraction()) {
                result = this.e2DblComArg((IComplexNum)o0, F.complexNum((IFraction)o1));
            } else if (o1 instanceof IComplexNum) {
                result = this.e2DblComArg((IComplexNum)o0, (IComplexNum)o1);
            }
            if (result != null) {
                return result;
            }
            return this.e2ObjArg(o0, o1);
        }
        if (o1 instanceof IComplexNum) {
            if (o0 instanceof INum) {
                result = this.e2DblComArg(F.complexNum(((INum)o0).getRealPart()), (IComplexNum)o1);
            } else if (o0.isInteger()) {
                result = this.e2DblComArg(F.complexNum((IInteger)o0), (IComplexNum)o1);
            } else if (o0.isFraction()) {
                result = this.e2DblComArg(F.complexNum((IFraction)o0), (IComplexNum)o1);
            }
            if (result != null) {
                return result;
            }
            return this.e2ObjArg(o0, o1);
        }
        if (o0 instanceof IInteger) {
            if (o1 instanceof IInteger) {
                return this.e2IntArg((IInteger)o0, (IInteger)o1);
            }
            if (o1 instanceof IFraction) {
                return this.e2FraArg(F.fraction((IInteger)o0, F.C1), (IFraction)o1);
            }
            if (o1 instanceof IComplex) {
                return this.e2ComArg(F.complex((IInteger)o0, F.C0), (IComplex)o1);
            }
        } else if (o0 instanceof IFraction) {
            if (o1 instanceof IInteger) {
                return this.e2FraArg((IFraction)o0, F.fraction((IInteger)o1, F.C1));
            }
            if (o1 instanceof IFraction) {
                return this.e2FraArg((IFraction)o0, (IFraction)o1);
            }
            if (o1 instanceof IComplex) {
                return this.e2ComArg(F.complex((IFraction)o0), (IComplex)o1);
            }
        } else if (o0 instanceof IComplex) {
            if (o1 instanceof IInteger) {
                return this.eComIntArg((IComplex)o0, (IInteger)o1);
            }
            if (o1 instanceof IComplex) {
                return this.e2ComArg((IComplex)o0, (IComplex)o1);
            }
        }
        if ((result = this.e2ObjArg(o0, o1)) != null) {
            return result;
        }
        if (o0 instanceof ISymbol && o1 instanceof ISymbol) {
            return this.e2SymArg((ISymbol)o0, (ISymbol)o1);
        }
        if (o0 instanceof IAST) {
            if (o1 instanceof IInteger) {
                return this.eFunIntArg((IAST)o0, (IInteger)o1);
            }
            if (o1 instanceof IAST) {
                return this.e2FunArg((IAST)o0, (IAST)o1);
            }
        }
        return null;
    }

    @Override
    public abstract IExpr e2IntArg(IInteger var1, IInteger var2);
}

