/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Writer;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.EvalUtilities;
import org.matheclipse.core.eval.exception.TimeExceeded;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IExpr;

public class TimeConstrainedEvaluator
extends EvalUtilities
implements Runnable {
    protected IExpr fEvaluationResult;
    protected Throwable fException;
    protected IExpr fParsedExpression;
    private long fMilliSeconds;
    private final boolean fRelaxedSyntax;
    private boolean fTraceEvaluation;

    public TimeConstrainedEvaluator(EvalEngine evalEngine, boolean msie, long milliSeconds) {
        this(evalEngine, msie, milliSeconds, false);
    }

    public TimeConstrainedEvaluator(EvalEngine evalEngine, boolean msie, long milliSeconds, boolean relaxedSyntax) {
        super(evalEngine, msie, relaxedSyntax);
        this.fMilliSeconds = milliSeconds;
        this.fRelaxedSyntax = relaxedSyntax;
        this.fTraceEvaluation = false;
    }

    @Override
    public void run() {
        try {
            this.startRequest();
            this.fEvaluationResult = this.fTraceEvaluation ? this.evalTrace(this.fParsedExpression, null, F.List()) : this.evaluate(this.fParsedExpression);
        }
        catch (Exception e) {
            this.fException = e;
        }
        catch (OutOfMemoryError e) {
            this.fEvaluationResult = F.stringx("OutOfMemoryError");
        }
        catch (StackOverflowError e) {
            this.fEvaluationResult = F.stringx("StackOverflowError");
        }
    }

    public IExpr constrainedEval(Writer writer, String inputString, boolean traceEvaluation) throws Exception {
        this.fEvaluationResult = null;
        this.fException = null;
        this.fParsedExpression = null;
        this.fEvalEngine.setStopRequested(false);
        this.fTraceEvaluation = traceEvaluation;
        EvalEngine.set(this.fEvalEngine);
        this.fParsedExpression = this.fEvalEngine.parse(inputString);
        return this.constrainedEval(writer, this.fParsedExpression);
    }

    public IExpr constrainedEval(Writer writer, IExpr inputExpression) throws Exception {
        this.fEvaluationResult = null;
        this.fException = null;
        this.fParsedExpression = inputExpression;
        this.fEvalEngine.setStopRequested(false);
        Thread thread = new Thread((Runnable)this, "TimeConstrainedEvaluator");
        thread.start();
        thread.join(this.fMilliSeconds);
        if (thread.isAlive()) {
            thread.interrupt();
            this.fEvalEngine.stopRequest();
            Thread.sleep(500L);
            if (thread.isAlive()) {
                thread.stop();
                throw new TimeExceeded();
            }
        }
        if (this.fException != null) {
            writer.write(this.fException.getMessage() != null ? this.fException.getMessage() : "Exception: " + this.fException.getClass().getName());
            writer.write(10);
        }
        if (this.fEvaluationResult != null && !this.fEvaluationResult.equals(F.Null)) {
            OutputFormFactory.get(this.fRelaxedSyntax).convert(writer, this.fEvaluationResult);
        }
        return this.fEvaluationResult;
    }

    public IExpr getParsedExpression() {
        return this.fParsedExpression;
    }
}

