/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.ISymbol;

public class Namespace {
    ArrayList<Namespace> fNamespaces = new ArrayList();
    ArrayList<String> fNamespacesString = new ArrayList();
    Map<String, Namespace> fPackageNamespaceMap = new HashMap<String, Namespace>();
    public static final char[] NO_CHAR = new char[0];

    public boolean add(String arg) {
        this.fPackageNamespaceMap.put(arg, null);
        return this.fNamespacesString.add(arg);
    }

    public boolean add(Namespace arg) {
        this.fPackageNamespaceMap.put(arg.getClass().getPackage().getName(), arg);
        return this.fNamespaces.add(arg);
    }

    public void setEvaluator(ISymbol symbol) {
        String functionName;
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            String symbolName = symbol.toString().toLowerCase();
            functionName = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(symbolName);
        } else {
            functionName = symbol.toString();
        }
        if (functionName != null) {
            for (Map.Entry<String, Namespace> namespaceEntry : this.fPackageNamespaceMap.entrySet()) {
                Class<?> clazz;
                try {
                    clazz = namespaceEntry.getValue() == null ? Class.forName(namespaceEntry.getKey() + "." + functionName) : Class.forName(namespaceEntry.getKey() + "." + functionName, true, namespaceEntry.getValue().getClass().getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    clazz = null;
                }
                catch (NoClassDefFoundError e) {
                    clazz = null;
                }
                catch (Throwable se) {
                    se.printStackTrace();
                    clazz = null;
                }
                if (clazz == null) continue;
                try {
                    IEvaluator module = (IEvaluator)clazz.newInstance();
                    symbol.setEvaluator(module);
                    return;
                }
                catch (Throwable se) {
                    se.printStackTrace();
                }
            }
        }
    }

    public void setEquals(Symbol symbol) {
        for (int i = this.fNamespaces.size() - 1; i >= 0; --i) {
            Class<?> clazz;
            String namespace = this.fNamespaces.get(i) + symbol.toString();
            try {
                clazz = Class.forName(namespace);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            try {
                IEvaluator module = (IEvaluator)clazz.newInstance();
                symbol.setEvaluator(module);
                return;
            }
            catch (Throwable se) {
                se.printStackTrace();
            }
        }
    }
}

