/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class RotateLeft
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IExpr arg1 = F.eval(ast.arg1());
        try {
            if (arg1.isAST()) {
                IAST result = F.ast(arg1.head());
                if (ast.size() == 2) {
                    ASTRange range = ((IAST)arg1).args();
                    range.rotateLeft(result, 1);
                    return result;
                }
                IExpr arg2 = F.eval(ast.arg2());
                if (arg2.isInteger()) {
                    int n = Validate.checkIntType(ast, 2, 1);
                    ASTRange range = ((IAST)arg1).args();
                    range.rotateLeft(result, n);
                    return result;
                }
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }
}

