/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class JavaForm
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IExpr arg1 = F.eval(ast.arg1());
        boolean strictJava = false;
        if (ast.size() == 3) {
            IExpr arg2 = F.eval(ast.arg2());
            Options options = new Options(ast.topHead(), arg2);
            strictJava = options.isOption("Strict");
        }
        String resultStr = JavaForm.javaForm(arg1, strictJava);
        return F.stringx(resultStr);
    }

    public static String javaForm(IExpr arg1, boolean strictJava) {
        return arg1.internalFormString(strictJava, 0);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

