/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.list.algorithms.EvaluationSupport;

public class Flatten
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2);
        IExpr arg1 = F.eval(ast.arg1());
        IAST resultList = F.List();
        if (ast.size() == 2) {
            if (arg1.isList() && EvaluationSupport.flatten(F.List, (IAST)arg1, resultList)) {
                return resultList;
            }
            return arg1;
        }
        if (ast.size() == 3) {
            int level;
            IExpr arg2 = F.eval(ast.arg2());
            if (arg1.isList() && (level = Validate.checkIntType(arg2)) > 0 && EvaluationSupport.flatten(F.List, (IAST)arg1, resultList, 0, level)) {
                return resultList;
            }
            return arg1;
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

