/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class FixedPoint
extends AbstractCoreFunctionEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        try {
            IExpr last;
            EvalEngine engine = EvalEngine.get();
            int iterationLimit = engine.getIterationLimit();
            int iterationCounter = 1;
            IExpr f = ast.arg1();
            IExpr current = ast.arg2();
            int iterations = Integer.MAX_VALUE;
            if (ast.size() == 4) {
                iterations = Validate.checkIntType(ast, 3);
            }
            do {
                last = current;
                current = engine.evaluate(F.Apply(f, F.List(current)));
                if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
                IterationLimitExceeded.throwIt(iterationCounter, ast);
            } while (!current.isSame(last) && --iterations > 0);
            IExpr iExpr = current;
            return iExpr;
        }
        finally {
            EvalEngine.get().setNumericMode(false);
        }
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(96);
    }
}

