/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Delete
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        IExpr arg1 = F.eval(ast.arg1());
        IExpr arg2 = F.eval(ast.arg2());
        if (arg1.isAST() && arg2.isInteger()) {
            IAST list1 = (IAST)arg1;
            try {
                int indx = Validate.checkIntType(ast, 2, Integer.MIN_VALUE);
                if (indx < 0) {
                    indx = list1.size() + indx;
                }
                IAST result = list1.clone();
                result.remove(indx);
                return result;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }
}

