/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.combinatoric;

import java.util.Iterator;
import org.matheclipse.combinatoric.util.ArrayUtils;

public class RosenIterator
implements Iterator<int[]> {
    protected final int n;
    protected final int k;
    private int[] a;
    protected long count;

    public RosenIterator(int n, int k) {
        this.n = n;
        this.k = k;
        this.count = RosenIterator.count(n, k);
    }

    public void reset() {
        this.count = RosenIterator.count(this.n, this.k);
        this.a = null;
    }

    public static long count(int n, int k) {
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("0 <= k <= " + n + "!");
        }
        long count = 1L;
        for (int i = 0; i < k; ++i) {
            count = count * (long)(n - i) / (long)(i + 1);
        }
        return count;
    }

    @Override
    public final boolean hasNext() {
        return this.count > 0L;
    }

    @Override
    public int[] next() {
        if (this.a == null) {
            this.initialize();
        } else {
            int i = this.k - 1;
            while (this.a[i] == this.n - this.k + i) {
                --i;
            }
            this.a[i] = this.a[i] + 1;
            for (int j = i + 1; j < this.k; ++j) {
                this.a[j] = this.a[i] + j - i;
            }
        }
        --this.count;
        return this.a;
    }

    private void initialize() {
        this.a = ArrayUtils.identityPermutation(this.k);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator doesn't support the remove() method");
    }

    public static class Factory
    implements Iterable<int[]> {
        private final int n;
        private final int k;

        public Factory(int n, int k) {
            this.n = n;
            this.k = k;
        }

        @Override
        public final Iterator<int[]> iterator() {
            return new RosenIterator(this.n, this.k);
        }
    }
}

