/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.tsmm;

import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.tsmm.TimeSeriesAbstractModel;
import com.yahoo.egads.utilities.SpectralMethods;
import java.util.Hashtable;
import java.util.Properties;

public class SpectralSmoother
extends TimeSeriesAbstractModel {
    protected Hashtable<Long, Float> map;
    protected int windowSize;
    protected SpectralMethods.FilteringMethod method;
    protected double methodParameter;

    public SpectralSmoother(Properties config) {
        block11: {
            block10: {
                super(config);
                this.map = new Hashtable();
                if (config.getProperty("FILTERING_METHOD") == null) {
                    throw new IllegalArgumentException("FILTERING_METHOD is NULL");
                }
                if (config.getProperty("WINDOW_SIZE") == null) {
                    throw new IllegalArgumentException("WINDOW_SIZE is NULL");
                }
                this.windowSize = new Integer(config.getProperty("WINDOW_SIZE"));
                this.method = SpectralMethods.FilteringMethod.valueOf(config.getProperty("FILTERING_METHOD"));
                if (config.getProperty("FILTERING_PARAM") != null) break block10;
                switch (this.method) {
                    case VARIANCE: {
                        this.methodParameter = 0.99;
                        break block11;
                    }
                    case SMOOTHNESS: {
                        this.methodParameter = 0.97;
                        break block11;
                    }
                    case K_GAP: {
                        this.methodParameter = 8.0;
                        break block11;
                    }
                    case EXPLICIT: {
                        this.methodParameter = 10.0;
                        break block11;
                    }
                    case EIGEN_RATIO: {
                        this.methodParameter = 0.1;
                        break block11;
                    }
                    case GAP_RATIO: {
                        this.methodParameter = 0.01;
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid FILTERING_METHOD value");
                    }
                }
            }
            this.methodParameter = new Double(config.getProperty("FILTERING_PARAM"));
        }
    }

    @Override
    public void reset() {
        this.map.clear();
    }

    @Override
    public void train(TimeSeries.DataSequence data) throws Exception {
        this.reset();
        TimeSeries.DataSequence smoothedData = SpectralMethods.mFilter(data, this.windowSize, this.method, this.methodParameter);
        for (TimeSeries.Entry e : smoothedData) {
            this.map.put(e.logicalIndex, Float.valueOf(e.value));
        }
    }

    @Override
    public void update(TimeSeries.DataSequence data) throws Exception {
        TimeSeries.DataSequence smoothedData = SpectralMethods.mFilter(data, this.windowSize, this.method, this.methodParameter);
        for (TimeSeries.Entry e : smoothedData) {
            this.map.put(e.logicalIndex, Float.valueOf(e.value));
        }
    }

    @Override
    public void predict(TimeSeries.DataSequence sequence) throws Exception {
        for (TimeSeries.Entry e : sequence) {
            Float val = this.map.get(e.logicalIndex);
            e.value = val == null ? 0.0f : val.floatValue();
        }
    }

    @Override
    public String getModelName() {
        return "SpectralSmoother";
    }
}

