/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.adm;

import com.yahoo.egads.data.Anomaly;
import com.yahoo.egads.data.AnomalyErrorStorage;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.adm.AnomalyDetectionAbstractModel;
import com.yahoo.egads.utilities.DBSCANClusterer;
import com.yahoo.egads.utilities.IdentifiedDoublePoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.json.JSONObject;
import org.json.JSONStringer;

public class DBScanModel
extends AnomalyDetectionAbstractModel {
    private Map<String, Float> threshold;
    private int maxHrsAgo;
    private long windowStart;
    public String modelName = "DBScanModel";
    public AnomalyErrorStorage aes = new AnomalyErrorStorage();
    private DBSCANClusterer<IdentifiedDoublePoint> dbscan = null;
    private int minPoints = 2;
    private double eps = 500.0;

    public DBScanModel(Properties config) {
        super(config);
        if (config.getProperty("MAX_ANOMALY_TIME_AGO") == null) {
            throw new IllegalArgumentException("MAX_ANOMALY_TIME_AGO is NULL");
        }
        this.maxHrsAgo = new Integer(config.getProperty("MAX_ANOMALY_TIME_AGO"));
        this.windowStart = new Long(config.getProperty("DETECTION_WINDOW_START_TIME"));
        this.threshold = this.parseMap(config.getProperty("THRESHOLD"));
        if (config.getProperty("THRESHOLD") != null && this.threshold.isEmpty()) {
            throw new IllegalArgumentException("THRESHOLD PARSE ERROR");
        }
    }

    @Override
    public void toJson(JSONStringer json_out) {
    }

    @Override
    public void fromJson(JSONObject json_obj) {
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public String getType() {
        return "point_outlier";
    }

    @Override
    public void reset() {
    }

    @Override
    public void tune(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries, Anomaly.IntervalSequence anomalySequence) throws Exception {
        HashMap<String, ArrayList<Float>> allErrors = this.aes.initAnomalyErrors(observedSeries, expectedSeries);
        ArrayList<IdentifiedDoublePoint> points = new ArrayList<IdentifiedDoublePoint>();
        EuclideanDistance ed = new EuclideanDistance();
        int n = observedSeries.size();
        for (int i = 0; i < n; ++i) {
            double[] d = new double[this.aes.getIndexToError().keySet().size()];
            for (int e = 0; e < this.aes.getIndexToError().keySet().size(); ++e) {
                d[e] = allErrors.get(this.aes.getIndexToError().get(e)).get(i).floatValue();
            }
            points.add(new IdentifiedDoublePoint(d, i));
        }
        double sum = 0.0;
        double count = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                sum += ed.compute(((IdentifiedDoublePoint)((Object)points.get(i))).getPoint(), ((IdentifiedDoublePoint)((Object)points.get(j))).getPoint());
                count += 1.0;
            }
        }
        this.eps = (double)this.sDAutoSensitivity * (sum / count);
        this.minPoints = (int)Math.ceil((double)this.amntAutoSensitivity * (double)n);
        this.dbscan = new DBSCANClusterer(this.eps, this.minPoints);
    }

    @Override
    public Anomaly.IntervalSequence detect(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries) throws Exception {
        Anomaly.IntervalSequence output = new Anomaly.IntervalSequence();
        int n = observedSeries.size();
        Float[] thresholdErrors = new Float[this.aes.getErrorToIndex().size()];
        for (Map.Entry<String, Float> entry : this.threshold.entrySet()) {
            thresholdErrors[this.aes.getErrorToIndex().get((Object)entry.getKey()).intValue()] = Float.valueOf(Math.abs(entry.getValue().floatValue()));
        }
        HashMap<String, ArrayList<Float>> allErrors = this.aes.initAnomalyErrors(observedSeries, expectedSeries);
        ArrayList<IdentifiedDoublePoint> points = new ArrayList<IdentifiedDoublePoint>();
        for (int i = 0; i < n; ++i) {
            double[] d = new double[this.aes.getIndexToError().keySet().size()];
            for (int e = 0; e < this.aes.getIndexToError().keySet().size(); ++e) {
                d[e] = allErrors.get(this.aes.getIndexToError().get(e)).get(i).floatValue();
            }
            points.add(new IdentifiedDoublePoint(d, i));
        }
        List<Cluster<IdentifiedDoublePoint>> cluster = this.dbscan.cluster(points);
        for (Cluster<IdentifiedDoublePoint> c : cluster) {
            for (IdentifiedDoublePoint p : c.getPoints()) {
                int i = p.getId();
                Float[] errors = this.aes.computeErrorMetrics(((TimeSeries.Entry)expectedSeries.get((int)p.getId())).value, ((TimeSeries.Entry)observedSeries.get((int)p.getId())).value);
                this.logger.debug("TS:" + ((TimeSeries.Entry)observedSeries.get((int)i)).time + ",E:" + this.arrayF2S(errors) + ",TE:" + this.arrayF2S(thresholdErrors) + ",OV:" + ((TimeSeries.Entry)observedSeries.get((int)i)).value + ",EV:" + ((TimeSeries.Entry)expectedSeries.get((int)i)).value);
                if (((TimeSeries.Entry)observedSeries.get((int)p.getId())).value == ((TimeSeries.Entry)expectedSeries.get((int)p.getId())).value || !this.isDetectionWindowPoint(this.maxHrsAgo, this.windowStart, ((TimeSeries.Entry)observedSeries.get((int)p.getId())).time, ((TimeSeries.Entry)observedSeries.get((int)0)).time) && (this.maxHrsAgo != 0 || p.getId() != n - 1)) continue;
                output.add(new Anomaly.Interval(((TimeSeries.Entry)observedSeries.get((int)p.getId())).time, p.getId(), errors, thresholdErrors, ((TimeSeries.Entry)observedSeries.get((int)p.getId())).value, ((TimeSeries.Entry)expectedSeries.get((int)p.getId())).value));
            }
        }
        return output;
    }
}

