/*
 * Decompiled with CFR 0.152.
 */
package com.github.servicenow.ds.stats.stl;

import com.github.servicenow.ds.stats.stl.LoessInterpolator;

public class LoessSmoother {
    private final LoessInterpolator fInterpolator;
    private final double[] fData;
    private final int fWidth;
    private final int fJump;
    private final double[] fSmoothed;

    private LoessSmoother(int width, int jump, int degree, double[] data, double[] externalWeights) {
        LoessInterpolator.Builder b = new LoessInterpolator.Builder();
        this.fInterpolator = b.setWidth(width).setDegree(degree).setExternalWeights(externalWeights).interpolate(data);
        this.fData = data;
        this.fJump = Math.min(jump, data.length - 1);
        this.fWidth = width;
        this.fSmoothed = new double[data.length];
    }

    public LoessInterpolator getInterpolator() {
        return this.fInterpolator;
    }

    public double[] smooth() {
        Double y;
        int halfWidth;
        int i;
        if (this.fData.length == 1) {
            this.fSmoothed[0] = this.fData[0];
            return this.fSmoothed;
        }
        int left = -1;
        int right = -1;
        if (this.fWidth >= this.fData.length) {
            left = 0;
            right = this.fData.length - 1;
            for (i = 0; i < this.fData.length; i += this.fJump) {
                Double y2 = this.fInterpolator.smoothOnePoint(i, left, right);
                this.fSmoothed[i] = y2 == null ? this.fData[i] : y2;
            }
        } else if (this.fJump == 1) {
            halfWidth = (this.fWidth + 1) / 2;
            left = 0;
            right = this.fWidth - 1;
            for (int i2 = 0; i2 < this.fData.length; ++i2) {
                if (i2 >= halfWidth && right != this.fData.length - 1) {
                    ++left;
                    ++right;
                }
                this.fSmoothed[i2] = (y = this.fInterpolator.smoothOnePoint(i2, left, right)) == null ? this.fData[i2] : y;
            }
        } else {
            halfWidth = (this.fWidth + 1) / 2;
            for (int i3 = 0; i3 < this.fData.length; i3 += this.fJump) {
                left = i3 < halfWidth - 1 ? 0 : (i3 >= this.fData.length - halfWidth ? this.fData.length - this.fWidth : i3 - halfWidth + 1);
                right = left + this.fWidth - 1;
                y = this.fInterpolator.smoothOnePoint(i3, left, right);
                this.fSmoothed[i3] = y == null ? this.fData[i3] : y;
            }
        }
        if (this.fJump != 1) {
            for (i = 0; i < this.fData.length - this.fJump; i += this.fJump) {
                double slope = (this.fSmoothed[i + this.fJump] - this.fSmoothed[i]) / (double)this.fJump;
                for (int j = i + 1; j < i + this.fJump; ++j) {
                    this.fSmoothed[j] = this.fSmoothed[i] + slope * (double)(j - i);
                }
            }
            int last = this.fData.length - 1;
            int lastSmoothedPos = last / this.fJump * this.fJump;
            if (lastSmoothedPos != last) {
                y = this.fInterpolator.smoothOnePoint(last, left, right);
                double d = this.fSmoothed[last] = y == null ? this.fData[last] : y;
                if (lastSmoothedPos != last - 1) {
                    double slope = (this.fSmoothed[last] - this.fSmoothed[lastSmoothedPos]) / (double)(last - lastSmoothedPos);
                    for (int j = lastSmoothedPos + 1; j < last; ++j) {
                        this.fSmoothed[j] = this.fSmoothed[lastSmoothedPos] + slope * (double)(j - lastSmoothedPos);
                    }
                }
            }
        }
        return this.fSmoothed;
    }

    public static class Builder {
        private Integer fWidth = null;
        private int fDegree = 1;
        private int fJump = 1;
        private double[] fExternalWeights = null;
        private double[] fData = null;

        public Builder setWidth(int width) {
            this.fWidth = width;
            return this;
        }

        public Builder setDegree(int degree) {
            if (degree < 0 || degree > 2) {
                throw new IllegalArgumentException("Degree must be 0, 1 or 2");
            }
            this.fDegree = degree;
            return this;
        }

        public Builder setJump(int jump) {
            this.fJump = jump;
            return this;
        }

        public Builder setExternalWeights(double[] weights) {
            this.fExternalWeights = weights;
            return this;
        }

        public Builder setData(double[] data) {
            this.fData = data;
            return this;
        }

        public LoessSmoother build() {
            if (this.fWidth == null) {
                throw new IllegalStateException("LoessSmoother.Builder: Width must be set before calling build");
            }
            if (this.fData == null) {
                throw new IllegalStateException("LoessSmoother.Builder: Data must be set before calling build");
            }
            return new LoessSmoother(this.fWidth, this.fJump, this.fDegree, this.fData, this.fExternalWeights);
        }
    }
}

