/*
 * Decompiled with CFR 0.152.
 */
package com.github.servicenow.ds.stats.stl;

import com.github.servicenow.ds.stats.stl.LoessInterpolator;
import com.github.servicenow.ds.stats.stl.LoessSmoother;

public class CyclicSubSeriesSmoother {
    private final double[][] fRawCyclicSubSeries;
    private final double[][] fSmoothedCyclicSubSeries;
    private final double[][] fSubSeriesWeights;
    private final int fPeriodLength;
    private final int fNumPeriods;
    private final int fRemainder;
    private final int fNumPeriodsToExtrapolateBackward;
    private final int fNumPeriodsToExtrapolateForward;
    private final int fWidth;
    private final LoessSmoother.Builder fLoessSmootherFactory;

    CyclicSubSeriesSmoother(int width, int degree, int jump, int dataLength, int periodicity, int numPeriodsToExtrapolateBackward, int numPeriodsToExtrapolateForward) {
        this.fWidth = width;
        this.fLoessSmootherFactory = new LoessSmoother.Builder().setWidth(width).setJump(jump).setDegree(degree);
        this.fPeriodLength = periodicity;
        this.fNumPeriods = dataLength / periodicity;
        this.fRemainder = dataLength % periodicity;
        this.fNumPeriodsToExtrapolateBackward = numPeriodsToExtrapolateBackward;
        this.fNumPeriodsToExtrapolateForward = numPeriodsToExtrapolateForward;
        this.fRawCyclicSubSeries = new double[periodicity][];
        this.fSmoothedCyclicSubSeries = new double[periodicity][];
        this.fSubSeriesWeights = new double[periodicity][];
        for (int period = 0; period < periodicity; ++period) {
            int seriesLength = period < this.fRemainder ? this.fNumPeriods + 1 : this.fNumPeriods;
            this.fRawCyclicSubSeries[period] = new double[seriesLength];
            this.fSmoothedCyclicSubSeries[period] = new double[this.fNumPeriodsToExtrapolateBackward + seriesLength + this.fNumPeriodsToExtrapolateForward];
            this.fSubSeriesWeights[period] = new double[seriesLength];
        }
    }

    public void smoothSeasonal(double[] rawData, double[] smoothedData, double[] weights) {
        this.extractRawSubSeriesAndWeights(rawData, weights);
        this.computeSmoothedSubSeries(weights != null);
        this.reconstructExtendedDataFromSubSeries(smoothedData);
    }

    private void computeSmoothedSubSeries(boolean useResidualWeights) {
        for (int period = 0; period < this.fPeriodLength; ++period) {
            double[] weights = useResidualWeights ? this.fSubSeriesWeights[period] : null;
            double[] rawData = this.fRawCyclicSubSeries[period];
            double[] smoothedData = this.fSmoothedCyclicSubSeries[period];
            this.smoothOneSubSeries(weights, rawData, smoothedData);
        }
    }

    private void extractRawSubSeriesAndWeights(double[] data, double[] weights) {
        for (int period = 0; period < this.fPeriodLength; ++period) {
            int cycleLength = period < this.fRemainder ? this.fNumPeriods + 1 : this.fNumPeriods;
            for (int i = 0; i < cycleLength; ++i) {
                this.fRawCyclicSubSeries[period][i] = data[i * this.fPeriodLength + period];
                if (weights == null) continue;
                this.fSubSeriesWeights[period][i] = weights[i * this.fPeriodLength + period];
            }
        }
    }

    private void reconstructExtendedDataFromSubSeries(double[] data) {
        for (int period = 0; period < this.fPeriodLength; ++period) {
            int cycleLength = period < this.fRemainder ? this.fNumPeriods + 1 : this.fNumPeriods;
            for (int i = 0; i < this.fNumPeriodsToExtrapolateBackward + cycleLength + this.fNumPeriodsToExtrapolateForward; ++i) {
                data[i * this.fPeriodLength + period] = this.fSmoothedCyclicSubSeries[period][i];
            }
        }
    }

    private void smoothOneSubSeries(double[] weights, double[] rawData, double[] smoothedData) {
        int cycleLength = rawData.length;
        LoessSmoother smoother = this.fLoessSmootherFactory.setData(rawData).setExternalWeights(weights).build();
        System.arraycopy(smoother.smooth(), 0, smoothedData, this.fNumPeriodsToExtrapolateBackward, cycleLength);
        LoessInterpolator interpolator = smoother.getInterpolator();
        int left = 0;
        int right = left + this.fWidth - 1;
        right = Math.min(right, cycleLength - 1);
        int leftValue = this.fNumPeriodsToExtrapolateBackward;
        for (int i = 1; i <= this.fNumPeriodsToExtrapolateBackward; ++i) {
            Double ys = interpolator.smoothOnePoint(-i, left, right);
            smoothedData[leftValue - i] = ys == null ? smoothedData[leftValue] : ys;
        }
        right = cycleLength - 1;
        left = right - this.fWidth + 1;
        left = Math.max(0, left);
        int rightValue = this.fNumPeriodsToExtrapolateBackward + right;
        for (int i = 1; i <= this.fNumPeriodsToExtrapolateForward; ++i) {
            Double ys = interpolator.smoothOnePoint(right + i, left, right);
            smoothedData[rightValue + i] = ys == null ? smoothedData[rightValue] : ys;
        }
    }

    public static class Builder {
        private Integer fWidth = null;
        private Integer fDataLength = null;
        private Integer fPeriodicity = null;
        private Integer fNumPeriodsBackward = null;
        private Integer fNumPeriodsForward = null;
        private int fDegree = 1;
        private int fJump = 1;

        public Builder setWidth(int width) {
            this.fWidth = width;
            return this;
        }

        public Builder setDegree(int degree) {
            if (degree < 0 || degree > 2) {
                throw new IllegalArgumentException("Degree must be 0, 1 or 2");
            }
            this.fDegree = degree;
            return this;
        }

        public Builder setJump(int jump) {
            this.fJump = jump;
            return this;
        }

        public Builder setDataLength(int dataLength) {
            this.fDataLength = dataLength;
            return this;
        }

        public Builder setPeriodicity(int periodicity) {
            this.fPeriodicity = periodicity;
            return this;
        }

        public Builder extrapolateForwardOnly(int periods) {
            this.fNumPeriodsForward = periods;
            this.fNumPeriodsBackward = 0;
            return this;
        }

        public Builder extrapolateForwardAndBack(int periods) {
            this.fNumPeriodsForward = periods;
            this.fNumPeriodsBackward = periods;
            return this;
        }

        public Builder setNumPeriodsForward(int periods) {
            this.fNumPeriodsForward = periods;
            return this;
        }

        public Builder setNumPeriodsBackward(int periods) {
            this.fNumPeriodsBackward = periods;
            return this;
        }

        public CyclicSubSeriesSmoother build() {
            this.checkSanity();
            return new CyclicSubSeriesSmoother(this.fWidth, this.fDegree, this.fJump, this.fDataLength, this.fPeriodicity, this.fNumPeriodsBackward, this.fNumPeriodsForward);
        }

        private void checkSanity() {
            if (this.fWidth == null) {
                throw new IllegalArgumentException("CyclicSubSeriesSmoother.Builder: setWidth must be called before building the smoother.");
            }
            if (this.fPeriodicity == null) {
                throw new IllegalArgumentException("CyclicSubSeriesSmoother.Builder: setPeriodicity must be called before building the smoother.");
            }
            if (this.fDataLength == null) {
                throw new IllegalArgumentException("CyclicSubSeriesSmoother.Builder: setDataLength must be called before building the smoother.");
            }
            if (this.fNumPeriodsBackward == null || this.fNumPeriodsForward == null) {
                throw new IllegalArgumentException("CyclicSubSeriesSmoother.Builder: Extrapolation settings must be provided.");
            }
        }
    }
}

