/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.opt;

import jdistlib.math.MultivariableFunction;
import jdistlib.math.opt.BobyqaConfig;
import jdistlib.math.opt.MultivariateOptimization;
import jdistlib.math.opt.OptimizationConfig;
import jdistlib.math.opt.OptimizationResult;

public class Bobyqa
extends MultivariateOptimization {
    @Override
    public OptimizationResult optimize(OptimizationConfig cfg) {
        BobyqaConfig bcfg = null;
        bcfg = cfg instanceof BobyqaConfig ? (BobyqaConfig)cfg : new BobyqaConfig(cfg);
        return Bobyqa.bobyqa(bcfg.initialGuess, bcfg.lowerBound, bcfg.upperBound, bcfg.objectiveFunction, bcfg.maxNumFunctionCall, bcfg.initialTrustRegionRadius, bcfg.stoppingTrustRegionRadius, bcfg.numInterpolationPoints, bcfg.isMinimize);
    }

    public static final OptimizationResult bobyqa(double[] x, double[] xl, double[] xu, MultivariableFunction calfun, int npt, double rhobeg, double rhoend, int maxfun, boolean isMinimize) {
        double rho;
        int n = x.length;
        int np = n + 1;
        int ndim = npt + n;
        int toRescue = 190;
        if (xl.length != n || xu.length != n) {
            throw new RuntimeException();
        }
        if (npt < n + 2 || npt > (n + 2) * np / 2) {
            throw new RuntimeException("Return from BOBYQA because NPT is not in the required interval");
        }
        double[] origx = x;
        double[] xbase = new double[n];
        double[][] xpt = new double[npt][n];
        double[] fval = new double[npt];
        double[] xopt = new double[n];
        double[] gopt = new double[n];
        double[] hq = new double[n * np / 2];
        double[] pq = new double[npt];
        double[][] bmat = new double[ndim][n];
        double[][] zmat = new double[npt][npt - np];
        double[] sl = new double[n];
        double[] su = new double[n];
        double[] xnew = new double[n];
        double[] xalt = new double[n];
        double[] d = new double[n];
        double[] vlag = new double[ndim];
        double[] work1 = new double[n];
        double[] work2 = new double[npt];
        double[] work3 = new double[npt];
        x = new double[n];
        System.arraycopy(origx, 0, x, 0, n);
        double two_rhobeg = 2.0 * rhobeg;
        for (int j = 0; j < n; ++j) {
            double temp = xu[j] - xl[j];
            if (temp < two_rhobeg) {
                throw new RuntimeException("Return from BOBYQA because one of the differences xu[i]-xl[i] is less than 2*RHOBEG");
            }
            sl[j] = xl[j] - x[j];
            su[j] = xu[j] - x[j];
            if (sl[j] >= -rhobeg) {
                if (sl[j] >= 0.0) {
                    x[j] = xl[j];
                    sl[j] = 0.0;
                    su[j] = temp;
                    continue;
                }
                x[j] = xl[j] + rhobeg;
                sl[j] = -rhobeg;
                su[j] = Math.max(xu[j] - x[j], rhobeg);
                continue;
            }
            if (!(su[j] <= rhobeg)) continue;
            if (su[j] <= 0.0) {
                x[j] = xu[j];
                sl[j] = -temp;
                su[j] = 0.0;
                continue;
            }
            x[j] = xu[j] - rhobeg;
            sl[j] = Math.min(xl[j] - x[j], -rhobeg);
            su[j] = rhobeg;
        }
        double[] gnew = new double[n];
        int nf = 0;
        int kopt = 0;
        int nptm = npt - np;
        int nh = n * np / 2;
        int[] temp = Bobyqa.prelim(x, xl, xu, calfun, rhobeg, maxfun, xbase, xpt, fval, gopt, hq, pq, bmat, zmat, sl, su, isMinimize);
        nf = temp[0];
        kopt = temp[1];
        double xoptsq = 0.0;
        double fsave = fval[0];
        double alpha = 0.0;
        double cauchy = 0.0;
        double adelt = 0.0;
        double beta = 0.0;
        double f = 0.0;
        double denom = 0.0;
        double den = 0.0;
        double ratio = 0.0;
        boolean loop = true;
        for (int i = 0; i < n; ++i) {
            double val = xopt[i] = xpt[kopt][i];
            xoptsq += val * val;
        }
        if (nf < npt) {
            loop = false;
        }
        int kbase = 0;
        int knew = -1;
        double delta = rho = rhobeg;
        double diffa = 0.0;
        double diffb = 0.0;
        double diffc = 0.0;
        int nresc = nf;
        int ntrits = 0;
        int nfsav = nf;
        int itest = 0;
        int label = 20;
        double dsq = 0.0;
        double crvmin = 0.0;
        double dnorm = 0.0;
        double distsq = 0.0;
        while (loop) {
            switch (label) {
                case 20: {
                    if (kopt != kbase) {
                        int ih = 0;
                        for (int j = 0; j < n; ++j) {
                            for (int i = 0; i <= j; ++i) {
                                if (i < j) {
                                    gopt[j] = gopt[j] + hq[ih] * xopt[i];
                                }
                                gopt[i] = gopt[i] + hq[ih] * xopt[j];
                                ++ih;
                            }
                        }
                        if (nf > npt) {
                            for (int k = 0; k < npt; ++k) {
                                double temp2 = 0.0;
                                for (int j = 0; j < n; ++j) {
                                    temp2 += xpt[k][j] * xopt[j];
                                }
                                temp2 = pq[k] * temp2;
                                for (int i = 0; i < n; ++i) {
                                    gopt[i] = gopt[i] + temp2 * xpt[k][i];
                                }
                            }
                        }
                    }
                    label = 60;
                    break;
                }
                case 60: {
                    int k;
                    double[] temp3 = Bobyqa.trsbox(xpt, xopt, gopt, hq, pq, sl, su, delta, xnew, d, gnew, dsq, crvmin);
                    dsq = temp3[0];
                    crvmin = temp3[1];
                    dnorm = Math.min(delta, Math.sqrt(dsq));
                    if (dnorm < 0.5 * rho) {
                        ntrits = -1;
                        distsq = 100.0 * rho * rho;
                        if (nf <= nfsav + 2) {
                            label = 650;
                            break;
                        }
                        double errbig = Math.max(Math.max(diffa, diffb), diffc);
                        if (crvmin > 0.0 && errbig > 0.125 * rho * rho * crvmin) {
                            label = 650;
                            break;
                        }
                        double bdtol = errbig / rho;
                        for (int j = 0; j < n; ++j) {
                            double bdtest = bdtol;
                            if (xnew[j] == sl[j]) {
                                bdtest = work1[j];
                            }
                            if (xnew[j] == su[j]) {
                                bdtest = -work1[j];
                            }
                            if (!(bdtest < bdtol)) continue;
                            int jp1 = j + 1;
                            double curv = hq[(jp1 + jp1 * jp1) / 2 - 1];
                            for (k = 0; k < npt; ++k) {
                                double val = xpt[k][j];
                                curv += pq[k] * val * val;
                            }
                            if (!((bdtest += 0.5 * curv * rho) < bdtol)) continue;
                            label = 650;
                            break;
                        }
                        label = 680;
                        break;
                    }
                    ++ntrits;
                    label = 90;
                    break;
                }
                case 90: {
                    if (dsq <= 0.001 * xoptsq) {
                        int i;
                        double fracsq = 0.25 * xoptsq;
                        double sumpq = 0.0;
                        for (int k = 0; k < npt; ++k) {
                            sumpq += pq[k];
                            double sum = -0.5 * xoptsq;
                            for (int i2 = 0; i2 < n; ++i2) {
                                sum += xpt[k][i2] * xopt[i2];
                            }
                            work2[k] = sum;
                            double temp4 = fracsq - 0.5 * sum;
                            for (i = 0; i < n; ++i) {
                                work1[i] = bmat[k][i];
                                vlag[i] = sum * xpt[k][i] + temp4 * xopt[i];
                                int ip = npt + i;
                                for (int j = 0; j <= i; ++j) {
                                    bmat[ip][j] = bmat[ip][j] + work1[i] * vlag[j] + vlag[i] * work1[j];
                                }
                            }
                        }
                        for (int jj = 0; jj < nptm; ++jj) {
                            double sumz = 0.0;
                            double sumw = 0.0;
                            for (int k = 0; k < npt; ++k) {
                                sumz += zmat[k][jj];
                                vlag[k] = work2[k] * zmat[k][jj];
                                sumw += vlag[k];
                            }
                            for (int j = 0; j < n; ++j) {
                                int k;
                                double sum = (fracsq * sumz - 0.5 * sumw) * xopt[j];
                                for (k = 0; k < npt; ++k) {
                                    sum += vlag[k] * xpt[k][j];
                                }
                                work1[j] = sum;
                                for (k = 0; k < npt; ++k) {
                                    bmat[k][j] = bmat[k][j] + sum * zmat[k][jj];
                                }
                            }
                            for (i = 0; i < n; ++i) {
                                int ip = i + npt;
                                double temp5 = work1[i];
                                for (int j = 0; j <= i; ++j) {
                                    bmat[ip][j] = bmat[ip][j] + temp5 * work1[j];
                                }
                            }
                        }
                        int ih = 0;
                        for (int j = 0; j < n; ++j) {
                            work1[j] = -0.5 * sumpq * xopt[j];
                            for (int k = 0; k < npt; ++k) {
                                work1[j] = work1[j] + pq[k] * xpt[k][j];
                                xpt[k][j] = xpt[k][j] - xopt[j];
                            }
                            for (int i3 = 0; i3 <= j; ++i3) {
                                hq[ih] = hq[ih] + work1[i3] * xopt[j] + xopt[i3] * work1[j];
                                bmat[npt + i3][j] = bmat[npt + j][i3];
                                ++ih;
                            }
                        }
                        for (int i4 = 0; i4 < n; ++i4) {
                            double xopti = xopt[i4];
                            xbase[i4] = xbase[i4] + xopti;
                            xnew[i4] = xnew[i4] - xopti;
                            sl[i4] = sl[i4] - xopti;
                            su[i4] = su[i4] - xopti;
                            xopt[i4] = 0.0;
                        }
                        xoptsq = 0.0;
                    }
                    label = ntrits == 0 ? 210 : 230;
                    break;
                }
                case 190: {
                    nfsav = nf;
                    kbase = kopt;
                    int[] temp6 = Bobyqa.rescue(xl, xu, calfun, maxfun, xbase, xpt, fval, xopt, gopt, hq, pq, bmat, zmat, sl, su, nf, delta, kopt, vlag, isMinimize);
                    nf = temp6[0];
                    kopt = temp6[1];
                    xoptsq = 0.0;
                    if (kopt != kbase) {
                        for (int i = 0; i < n; ++i) {
                            double val = xopt[i] = xpt[kopt][i];
                            xoptsq += val * val;
                        }
                    }
                    if (nf < 0) {
                        nf = maxfun;
                        loop = false;
                        label = 720;
                        break;
                    }
                    nresc = nf;
                    if (nfsav < nf) {
                        nfsav = nf;
                        label = 20;
                        break;
                    }
                    if (ntrits > 0) {
                        label = 60;
                        break;
                    }
                    label = 210;
                    break;
                }
                case 210: {
                    double[] temp7 = Bobyqa.altmov(xpt, xopt, bmat, zmat, sl, su, kopt, knew, adelt, xnew, xalt);
                    alpha = temp7[0];
                    cauchy = temp7[1];
                    for (int i = 0; i < n; ++i) {
                        d[i] = xnew[i] - xopt[i];
                    }
                    label = 230;
                    break;
                }
                case 230: {
                    int i6;
                    int k;
                    for (int k2 = 0; k2 < npt; ++k2) {
                        double suma = 0.0;
                        double sumb = 0.0;
                        double sum = 0.0;
                        for (int j = 0; j < n; ++j) {
                            suma += xpt[k2][j] * d[j];
                            sumb += xpt[k2][j] * xopt[j];
                            sum += bmat[k2][j] * d[j];
                        }
                        work3[k2] = suma * (0.5 * suma + sumb);
                        vlag[k2] = sum;
                        work2[k2] = suma;
                    }
                    beta = 0.0;
                    for (int jj = 0; jj < nptm; ++jj) {
                        int k3;
                        double sum = 0.0;
                        for (k3 = 0; k3 < npt; ++k3) {
                            sum += zmat[k3][jj] * work3[k3];
                        }
                        beta -= sum * sum;
                        for (k3 = 0; k3 < npt; ++k3) {
                            vlag[k3] = vlag[k3] + sum * zmat[k3][jj];
                        }
                    }
                    dsq = 0.0;
                    double bsum = 0.0;
                    double dx = 0.0;
                    for (int j = 0; j < n; ++j) {
                        double val = d[j];
                        dsq += val * val;
                        double sum = 0.0;
                        for (int k4 = 0; k4 < npt; ++k4) {
                            sum += work3[k4] * bmat[k4][j];
                        }
                        bsum += sum * d[j];
                        int jp = npt + j;
                        for (i6 = 0; i6 < n; ++i6) {
                            sum += bmat[jp][i6] * d[i6];
                        }
                        vlag[jp] = sum;
                        bsum += sum * d[j];
                        dx += d[j] * xopt[j];
                    }
                    beta = dx * dx + dsq * (xoptsq + dx + dx + 0.5 * dsq) + beta - bsum;
                    vlag[kopt] = vlag[kopt] + 1.0;
                    if (ntrits == 0) {
                        double val = vlag[knew];
                        denom = val * val + alpha * beta;
                        if (denom < cauchy && cauchy > 0.0) {
                            for (int i5 = 0; i5 < n; ++i5) {
                                xnew[i5] = xalt[i5];
                                d[i5] = xnew[i5] - xopt[i5];
                            }
                            cauchy = 0.0;
                            label = 230;
                            break;
                        }
                        if (denom <= 0.5 * val * val) {
                            if (nf > nresc) {
                                label = 190;
                                break;
                            }
                            loop = false;
                            label = 720;
                            break;
                        }
                    } else {
                        double delsq = delta * delta;
                        double scaden = 0.0;
                        double biglsq = 0.0;
                        knew = -1;
                        for (k = 0; k < npt; ++k) {
                            double val;
                            if (k == kopt) continue;
                            double hdiag = 0.0;
                            for (int jj = 0; jj < nptm; ++jj) {
                                val = zmat[k][jj];
                                hdiag += val * val;
                            }
                            val = vlag[k];
                            den = beta * hdiag + val * val;
                            distsq = 0.0;
                            for (int j = 0; j < n; ++j) {
                                val = xpt[k][j] - xopt[j];
                                distsq += val * val;
                            }
                            val = distsq / delsq;
                            double temp8 = Math.max(1.0, val * val);
                            if (temp8 * den > scaden) {
                                scaden = temp8 * den;
                                knew = k;
                                denom = den;
                            }
                            val = vlag[k];
                            biglsq = Math.max(biglsq, temp8 * val * val);
                        }
                        if (scaden <= 0.5 * biglsq) {
                            if (nf > nresc) {
                                label = 190;
                                break;
                            }
                            loop = false;
                            label = 720;
                            break;
                        }
                    }
                    label = 360;
                    break;
                }
                case 360: {
                    double sum;
                    int j;
                    int k;
                    double temp9;
                    int i;
                    int k5;
                    int i6;
                    for (int i7 = 0; i7 < n; ++i7) {
                        x[i7] = Math.min(Math.max(xl[i7], xbase[i7] + xnew[i7]), xu[i7]);
                        if (xnew[i7] == sl[i7]) {
                            x[i7] = xl[i7];
                        }
                        if (xnew[i7] != su[i7]) continue;
                        x[i7] = xu[i7];
                    }
                    if (nf >= maxfun) {
                        loop = false;
                        label = 720;
                        break;
                    }
                    ++nf;
                    double d2 = f = isMinimize ? calfun.eval(x) : -calfun.eval(x);
                    if (ntrits == -1) {
                        fsave = f;
                        loop = false;
                        label = 720;
                        break;
                    }
                    double fopt = fval[kopt];
                    double vquad = 0.0;
                    int ih = 0;
                    for (int j2 = 0; j2 < n; ++j2) {
                        vquad += d[j2] * gopt[j2];
                        for (i6 = 0; i6 <= j2; ++i6) {
                            double temp10 = d[i6] * d[j2];
                            if (i6 == j2) {
                                temp10 = 0.5 * temp10;
                            }
                            vquad += hq[ih] * temp10;
                            ++ih;
                        }
                    }
                    for (int k6 = 0; k6 < npt; ++k6) {
                        double val = work2[k6];
                        vquad += 0.5 * pq[k6] * val * val;
                    }
                    double diff = f - fopt - vquad;
                    diffc = diffb;
                    diffb = diffa;
                    diffa = Math.abs(diff);
                    if (dnorm > rho) {
                        nfsav = nf;
                    }
                    if (ntrits > 0) {
                        if (vquad >= 0.0) {
                            loop = false;
                            label = 720;
                            break;
                        }
                        ratio = (f - fopt) / vquad;
                        double d3 = ratio <= 0.1 ? Math.min(0.5 * delta, dnorm) : (delta = Math.max(0.5 * delta, ratio <= 0.7 ? dnorm : 2.0 * dnorm));
                        if (delta <= 1.5 * rho) {
                            delta = rho;
                        }
                        if (f < fopt) {
                            int ksav = knew;
                            double densav = denom;
                            double delsq = delta * delta;
                            double scaden = 0.0;
                            double biglsq = 0.0;
                            knew = -1;
                            for (k5 = 0; k5 < npt; ++k5) {
                                double val;
                                double hdiag = 0.0;
                                for (int jj = 0; jj < nptm; ++jj) {
                                    val = zmat[k5][jj];
                                    hdiag += val * val;
                                }
                                val = vlag[k5];
                                den = beta * hdiag + val * val;
                                distsq = 0.0;
                                for (int j3 = 0; j3 < n; ++j3) {
                                    val = xpt[k5][j3] - xnew[j3];
                                    distsq += val * val;
                                }
                                val = distsq / delsq;
                                double temp11 = Math.max(1.0, val * val);
                                if (temp11 * den > scaden) {
                                    scaden = temp11 * den;
                                    knew = k5;
                                    denom = den;
                                }
                                val = vlag[k5];
                                biglsq = Math.max(biglsq, temp11 * val * val);
                            }
                            if (scaden <= 0.5 * biglsq) {
                                knew = ksav;
                                denom = densav;
                            }
                        }
                    }
                    Bobyqa.update(bmat, zmat, vlag, beta, denom, knew);
                    ih = 0;
                    double pqold = pq[knew];
                    pq[knew] = 0.0;
                    for (i = 0; i < n; ++i) {
                        temp9 = pqold * xpt[knew][i];
                        for (int j4 = 0; j4 <= i; ++j4) {
                            hq[ih] = hq[ih] + temp9 * xpt[knew][j4];
                            ++ih;
                        }
                    }
                    for (int jj = 0; jj < nptm; ++jj) {
                        temp9 = diff * zmat[knew][jj];
                        for (int k7 = 0; k7 < npt; ++k7) {
                            pq[k7] = pq[k7] + temp9 * zmat[k7][jj];
                        }
                    }
                    fval[knew] = f;
                    for (i = 0; i < n; ++i) {
                        xpt[knew][i] = xnew[i];
                        work1[i] = bmat[knew][i];
                    }
                    for (k = 0; k < npt; ++k) {
                        double suma = 0.0;
                        double sumb = 0.0;
                        for (int jj = 0; jj < nptm; ++jj) {
                            suma += zmat[knew][jj] * zmat[k][jj];
                        }
                        for (int j5 = 0; j5 < n; ++j5) {
                            sumb += xpt[k][j5] * xopt[j5];
                        }
                        double temp12 = suma * sumb;
                        for (int i8 = 0; i8 < n; ++i8) {
                            work1[i8] = work1[i8] + temp12 * xpt[k][i8];
                        }
                    }
                    for (i = 0; i < n; ++i) {
                        gopt[i] = gopt[i] + diff * work1[i];
                    }
                    if (f < fopt) {
                        kopt = knew;
                        xoptsq = 0.0;
                        ih = 0;
                        for (j = 0; j < n; ++j) {
                            xopt[j] = xnew[j];
                            double val = xopt[j];
                            xoptsq += val * val;
                            for (int i9 = 0; i9 <= j; ++i9) {
                                if (i9 < j) {
                                    gopt[j] = gopt[j] + hq[ih] * d[i9];
                                }
                                gopt[i9] = gopt[i9] + hq[ih] * d[j];
                                ++ih;
                            }
                        }
                        for (k = 0; k < npt; ++k) {
                            temp9 = 0.0;
                            for (int j6 = 0; j6 < n; ++j6) {
                                temp9 += xpt[k][j6] * d[j6];
                            }
                            temp9 *= pq[k];
                            for (int i10 = 0; i10 < n; ++i10) {
                                gopt[i10] = gopt[i10] + temp9 * xpt[k][i10];
                            }
                        }
                    }
                    if (ntrits > 0) {
                        double sum2;
                        for (k = 0; k < npt; ++k) {
                            vlag[k] = fval[k] - fval[kopt];
                            work3[k] = 0.0;
                        }
                        for (j = 0; j < nptm; ++j) {
                            int k8;
                            sum2 = 0.0;
                            for (k8 = 0; k8 < npt; ++k8) {
                                sum2 += zmat[k8][j] * vlag[k8];
                            }
                            for (k8 = 0; k8 < npt; ++k8) {
                                work3[k8] = work3[k8] + sum2 * zmat[k8][j];
                            }
                        }
                        for (k = 0; k < npt; ++k) {
                            sum2 = 0.0;
                            for (int j7 = 0; j7 < n; ++j7) {
                                sum2 += xpt[k][j7] * xopt[j7];
                            }
                            work2[k] = work3[k];
                            work3[k] = work3[k] * sum2;
                        }
                        double gqsq = 0.0;
                        double gisq = 0.0;
                        for (int i11 = 0; i11 < n; ++i11) {
                            double val;
                            sum = 0.0;
                            for (k5 = 0; k5 < npt; ++k5) {
                                sum += bmat[k5][i11] * vlag[k5] + xpt[k5][i11] * work3[k5];
                            }
                            if (xopt[i11] == sl[i11]) {
                                val = Math.min(0.0, gopt[i11]);
                                gqsq += val * val;
                                val = Math.min(0.0, sum);
                                gisq += val * val;
                            } else if (xopt[i11] == su[i11]) {
                                val = Math.max(0.0, gopt[i11]);
                                gqsq += val * val;
                                val = Math.max(0.0, sum);
                                gisq += val * val;
                            } else {
                                val = gopt[i11];
                                gqsq += val * val;
                                gisq += sum * sum;
                            }
                            vlag[npt + i11] = sum;
                        }
                        ++itest;
                        if (gqsq < 10.0 * gisq) {
                            itest = 0;
                        }
                        if (itest >= 3) {
                            int val = Math.max(npt, nh);
                            for (int i12 = 0; i12 < val; ++i12) {
                                if (i12 < n) {
                                    gopt[i12] = vlag[npt + i12];
                                }
                                if (i12 < npt) {
                                    pq[i12] = work2[i12];
                                }
                                if (i12 >= nh) continue;
                                hq[i12] = 0.0;
                            }
                            itest = 0;
                        }
                    }
                    if (ntrits == 0 || f <= fopt + 0.1 * vquad) {
                        label = 60;
                        break;
                    }
                    double v1 = 2.0 * delta;
                    double v2 = 10.0 * rho;
                    distsq = Math.max(v1 * v1, v2 * v2);
                    label = 650;
                    break;
                }
                case 650: {
                    double sum;
                    knew = -1;
                    for (int k = 0; k < npt; ++k) {
                        sum = 0.0;
                        for (int j = 0; j < n; ++j) {
                            double val = xpt[k][j] - xopt[j];
                            sum += val * val;
                        }
                        if (!(sum > distsq)) continue;
                        knew = k;
                        distsq = sum;
                    }
                    if (knew >= 0) {
                        double dist = Math.sqrt(distsq);
                        if (ntrits == -1 && (delta = Math.min(0.1 * delta, 0.5 * dist)) <= 1.5 * rho) {
                            delta = rho;
                        }
                        ntrits = 0;
                        adelt = Math.max(Math.min(0.1 * dist, delta), rho);
                        dsq = adelt * adelt;
                        label = 90;
                        break;
                    }
                    if (ntrits != -1 && (ratio > 0.0 || Math.max(delta, dnorm) > 0.0)) {
                        label = 60;
                        break;
                    }
                    label = 680;
                    break;
                }
                case 680: {
                    if (rho > rhoend) {
                        delta = 0.5 * rho;
                        ratio = rho / rhoend;
                        rho = ratio <= 16.0 ? rhoend : (ratio <= 250.0 ? Math.sqrt(ratio) * rhoend : 0.1 * rho);
                        delta = Math.max(delta, rho);
                        ntrits = 0;
                        nfsav = nf;
                        label = 60;
                        break;
                    }
                    if (ntrits == -1) {
                        label = 360;
                        break;
                    }
                    loop = false;
                    label = 720;
                }
            }
        }
        if (fval[kopt] <= fsave) {
            for (int i = 0; i < n; ++i) {
                x[i] = Math.min(Math.max(xl[i], xbase[i] + xopt[i]), xu[i]);
                if (xopt[i] == sl[i]) {
                    x[i] = xl[i];
                }
                if (xopt[i] != su[i]) continue;
                x[i] = xu[i];
            }
            f = fval[kopt];
        }
        return new OptimizationResult(x, f, nf, isMinimize);
    }

    private static final int[] prelim(double[] x, double[] xl, double[] xu, MultivariableFunction calfun, double rhobeg, int maxfun, double[] xbase, double[][] xpt, double[] fval, double[] gopt, double[] hq, double[] pq, double[][] bmat, double[][] zmat, double[] sl, double[] su, boolean isMinimize) {
        int kopt = 0;
        int n = x.length;
        int ndim = bmat.length;
        int npt = zmat.length;
        int mult = isMinimize ? 1 : -1;
        double rhosq = rhobeg * rhobeg;
        double recip = 1.0 / rhosq;
        double fbeg = 0.0;
        int np = n + 1;
        int nnpdiv2 = n * np / 2;
        int nptminnp = npt - np;
        for (int j = 0; j < n; ++j) {
            xbase[j] = x[j];
            for (int k = 0; k < npt; ++k) {
                xpt[k][j] = 0.0;
            }
            for (int i = 0; i < ndim; ++i) {
                bmat[i][j] = 0.0;
            }
        }
        for (int ih = 0; ih < nnpdiv2; ++ih) {
            hq[ih] = 0.0;
        }
        for (int k = 0; k < npt; ++k) {
            pq[k] = 0.0;
            for (int j = 0; j < nptminnp; ++j) {
                zmat[k][j] = 0.0;
            }
        }
        int nf = 0;
        int ipt = 0;
        int jpt = 0;
        double stepa = 0.0;
        double stepb = 0.0;
        do {
            double temp;
            int ih;
            double f;
            int nfm = nf;
            int nfx = nf - n;
            ++nf;
            if (nfm <= 2 * n) {
                if (nfm >= 1 && nfm <= n) {
                    xpt[nf - 1][nfm - 1] = stepa = su[nfm - 1] == 0.0 ? -rhobeg : rhobeg;
                } else if (nfm > n) {
                    stepa = xpt[nf - n - 1][nfx - 1];
                    stepb = -rhobeg;
                    if (sl[nfx - 1] == 0.0) {
                        stepb = Math.min(2.0 * rhobeg, su[nfx - 1]);
                    }
                    if (su[nfx - 1] == 0.0) {
                        stepb = Math.max(-2.0 * rhobeg, sl[nfx - 1]);
                    }
                    xpt[nf - 1][nfx - 1] = stepb;
                }
            } else {
                int itemp = (nfm - np) / n;
                jpt = nfm - itemp * n - n;
                ipt = jpt + itemp;
                if (ipt > n) {
                    itemp = jpt;
                    jpt = ipt - n;
                    ipt = itemp;
                }
                xpt[nf - 1][ipt - 1] = xpt[ipt][ipt - 1];
                xpt[nf - 1][jpt - 1] = xpt[jpt][jpt - 1];
            }
            for (int j = 0; j < n; ++j) {
                x[j] = Math.min(Math.max(xl[j], xbase[j] + xpt[nf - 1][j]), xu[j]);
                if (xpt[nf - 1][j] == sl[j]) {
                    x[j] = xl[j];
                }
                if (xpt[nf - 1][j] != su[j]) continue;
                x[j] = xu[j];
            }
            fval[nf - 1] = f = calfun.eval(x) * (double)mult;
            if (nf == 1) {
                fbeg = f;
                kopt = 1;
            } else if (f < fval[kopt - 1]) {
                kopt = nf;
            }
            if (nf <= 2 * n + 1) {
                if (nf >= 2 && nf <= n + 1) {
                    gopt[nfm - 1] = (f - fbeg) / stepa;
                    if (npt >= nf + n) continue;
                    bmat[0][nfm - 1] = -1.0 / stepa;
                    bmat[nf - 1][nfm - 1] = 1.0 / stepa;
                    bmat[npt + nfm - 1][nfm - 1] = -0.5 * rhosq;
                    continue;
                }
                if (nf < n + 2) continue;
                ih = nfx * (nfx + 1) / 2;
                temp = (f - fbeg) / stepb;
                double diff = stepb - stepa;
                hq[ih - 1] = 2.0 * (temp - gopt[nfx - 1]) / diff;
                gopt[nfx - 1] = (gopt[nfx - 1] * stepb - temp * stepa) / diff;
                if (stepa * stepb < 0.0 && f < fval[nf - n - 1]) {
                    fval[nf - 1] = fval[nf - n - 1];
                    fval[nf - n - 1] = f;
                    if (kopt == nf) {
                        kopt = nf - n;
                    }
                    xpt[nf - n - 1][nfx - 1] = stepb;
                    xpt[nf - 1][nfx - 1] = stepa;
                }
                bmat[0][nfx - 1] = -(stepa + stepb) / (stepa * stepb);
                bmat[nf - 1][nfx - 1] = -0.5 / xpt[nf - n - 1][nfx - 1];
                bmat[nf - n - 1][nfx - 1] = -bmat[0][nfx - 1] - bmat[nf - 1][nfx - 1];
                zmat[0][nfx - 1] = Math.sqrt(2.0) / (stepa * stepb);
                zmat[nf - 1][nfx - 1] = Math.sqrt(0.5) / rhosq;
                zmat[nf - n - 1][nfx - 1] = -zmat[0][nfx - 1] - zmat[nf - 1][nfx - 1];
                continue;
            }
            ih = ipt * (ipt - 1) / 2 + jpt;
            double d = recip;
            zmat[nf - 1][nfx - 1] = d;
            zmat[0][nfx - 1] = d;
            double d2 = -recip;
            zmat[jpt][nfx - 1] = d2;
            zmat[ipt][nfx - 1] = d2;
            temp = xpt[nf - 1][ipt - 1] * xpt[nf - 1][jpt - 1];
            hq[ih - 1] = (fbeg - fval[ipt] - fval[jpt] + f) / temp;
        } while (nf < npt && nf < maxfun);
        return new int[]{nf, kopt - 1};
    }

    private static final void update(double[][] bmat, double[][] zmat, double[] vlag, double beta, double denom, int knew) {
        int ndim = bmat.length;
        int n = bmat[0].length;
        int npt = zmat.length;
        int nptm = npt - n - 1;
        double ztest = 0.0;
        double[] w = new double[ndim];
        for (int k = 0; k < npt; ++k) {
            for (int j = 0; j < nptm; ++j) {
                ztest = Math.max(ztest, Math.abs(zmat[k][j]));
            }
        }
        ztest *= 1.0E-20;
        for (int j = 1; j < nptm; ++j) {
            if (Math.abs(zmat[knew][j]) > ztest) {
                double tempa = zmat[knew][0];
                double tempb = zmat[knew][j];
                double temp = Math.sqrt(tempa * tempa + tempb * tempb);
                tempa /= temp;
                tempb /= temp;
                for (int i = 0; i < npt; ++i) {
                    temp = tempa * zmat[i][0] + tempb * zmat[i][j];
                    zmat[i][j] = tempa * zmat[i][j] - tempb * zmat[i][0];
                    zmat[i][0] = temp;
                }
            }
            zmat[knew][j] = 0.0;
        }
        for (int i = 0; i < npt; ++i) {
            w[i] = zmat[knew][0] * zmat[i][0];
        }
        double alpha = w[knew];
        double tau = vlag[knew];
        double temp = Math.sqrt(denom);
        double tempb = zmat[knew][0] / temp;
        double tempa = tau / temp;
        vlag[knew] = vlag[knew] - 1.0;
        for (int i = 0; i < npt; ++i) {
            zmat[i][0] = tempa * zmat[i][0] - tempb * vlag[i];
        }
        for (int j = 0; j < n; ++j) {
            int jp = npt + j;
            w[jp] = bmat[knew][j];
            tempa = (alpha * vlag[jp] - tau * w[jp]) / denom;
            tempb = (-beta * w[jp] - tau * vlag[jp]) / denom;
            for (int i = 0; i <= jp; ++i) {
                bmat[i][j] = bmat[i][j] + tempa * vlag[i] + tempb * w[i];
                if (i < npt) continue;
                bmat[jp][i - npt] = bmat[i][j];
            }
        }
    }

    private static final int[] rescue(double[] xl, double[] xu, MultivariableFunction calfun, int maxfun, double[] xbase, double[][] xpt, double[] fval, double[] xopt, double[] gopt, double[] hq, double[] pq, double[][] bmat, double[][] zmat, double[] sl, double[] su, int nf, double delta, int kopt, double[] vlag, boolean isMinimize) {
        int ip;
        int j;
        double temp;
        int i;
        int j2;
        int j3;
        int n = xl.length;
        int ndim = bmat.length;
        int npt = xpt.length;
        int np = n + 1;
        int mult = isMinimize ? 1 : -1;
        int nptm = npt - np;
        assert (npt == zmat.length);
        double sfrac = 0.5 / (double)np;
        double beta = 0.0;
        double denom = 0.0;
        double[][] ptsaux = new double[2][n];
        double[] ptsid = new double[npt];
        double[] w = new double[ndim + npt];
        double sumpq = 0.0;
        double winc = 0.0;
        for (int k = 0; k < npt; ++k) {
            double distsq = 0.0;
            for (j3 = 0; j3 < n; ++j3) {
                xpt[k][j3] = xpt[k][j3] - xopt[j3];
                double temp2 = xpt[k][j3];
                distsq += temp2 * temp2;
            }
            sumpq += pq[k];
            w[ndim + k] = distsq;
            winc = Math.max(winc, distsq);
            for (j3 = 0; j3 < nptm; ++j3) {
                zmat[k][j3] = 0.0;
            }
        }
        int ih = 0;
        for (j2 = 0; j2 < n; ++j2) {
            w[j2] = 0.5 * sumpq * xopt[j2];
            for (int k = 0; k < npt; ++k) {
                w[j2] = w[j2] + pq[k] * xpt[k][j2];
            }
            for (i = 0; i <= j2; ++i) {
                hq[ih] = hq[ih] + w[i] * xopt[j2] + w[j2] * xopt[i];
                ++ih;
            }
        }
        for (j2 = 0; j2 < n; ++j2) {
            xbase[j2] = xbase[j2] + xopt[j2];
            sl[j2] = sl[j2] - xopt[j2];
            su[j2] = su[j2] - xopt[j2];
            xopt[j2] = 0.0;
            ptsaux[0][j2] = Math.min(delta, su[j2]);
            ptsaux[1][j2] = Math.max(-delta, sl[j2]);
            if (ptsaux[0][j2] + ptsaux[1][j2] < 0.0) {
                double temp3 = ptsaux[0][j2];
                ptsaux[0][j2] = ptsaux[1][j2];
                ptsaux[1][j2] = temp3;
            }
            if (Math.abs(ptsaux[1][j2]) < 0.5 * Math.abs(ptsaux[0][j2])) {
                ptsaux[1][j2] = 0.5 * ptsaux[0][j2];
            }
            for (i = 0; i < ndim; ++i) {
                bmat[i][j2] = 0.0;
            }
        }
        double fbase = fval[kopt];
        ptsid[0] = sfrac;
        for (j3 = 0; j3 < n; ++j3) {
            int jp = j3 + 1;
            int jpn = jp + n;
            double ptsaux1j = ptsaux[0][j3];
            double ptsaux2j = ptsaux[1][j3];
            ptsid[jp] = (double)j3 + sfrac;
            if (jpn < npt) {
                ptsid[jpn] = (double)j3 * 1.0 / (double)np + sfrac;
                double temp4 = 1.0 / (ptsaux1j - ptsaux2j);
                bmat[jp][j3] = -temp4 + 1.0 / ptsaux1j;
                bmat[jpn][j3] = temp4 + 1.0 / ptsaux2j;
                bmat[0][j3] = -bmat[jp][j3] - bmat[jpn][j3];
                zmat[0][j3] = Math.sqrt(2.0) / Math.abs(ptsaux1j * ptsaux2j);
                zmat[jp][j3] = zmat[0][j3] * ptsaux2j * temp4;
                zmat[jpn][j3] = -zmat[0][j3] * ptsaux1j * temp4;
                continue;
            }
            bmat[0][j3] = -1.0 / ptsaux1j;
            bmat[jp][j3] = 1.0 / ptsaux1j;
            bmat[j3 + npt][j3] = -0.5 * ptsaux1j * ptsaux1j;
        }
        if (npt >= n + np) {
            for (int k = 2 * np - 1; k < npt; ++k) {
                int iw = (int)(((double)(k - np) - 0.5) / (double)n);
                int ip2 = k - np - iw * n;
                int iq = ip2 + iw;
                int knpm1 = k - np;
                if (iq >= n) {
                    iq -= n;
                }
                ptsid[k] = (double)ip2 + (double)iq * 1.0 / (double)np + sfrac;
                zmat[0][knpm1] = temp = 1.0 / (ptsaux[0][ip2] * ptsaux[1][iq]);
                zmat[ip2][knpm1] = -temp;
                zmat[iq][knpm1] = -temp;
                zmat[k][knpm1] = temp;
            }
        }
        int nrem = npt;
        int kold = 0;
        int knew = kopt;
        boolean gotoL120 = false;
        while (true) {
            double sum;
            int j4;
            int k;
            if (!gotoL120) {
                int j5;
                for (j5 = 0; j5 < n; ++j5) {
                    temp = bmat[kold][j5];
                    bmat[kold][j5] = bmat[knew][j5];
                    bmat[knew][j5] = temp;
                }
                for (j5 = 0; j5 < nptm; ++j5) {
                    temp = zmat[kold][j5];
                    zmat[kold][j5] = zmat[knew][j5];
                    zmat[knew][j5] = temp;
                }
                ptsid[kold] = ptsid[knew];
                ptsid[knew] = 0.0;
                w[ndim + knew] = 0.0;
                --nrem;
                if (knew != kopt) {
                    double temp5 = vlag[kold];
                    vlag[kold] = vlag[knew];
                    vlag[knew] = temp5;
                    Bobyqa.update(bmat, zmat, vlag, beta, denom, knew);
                    if (nrem == 0) {
                        return new int[]{nf, kopt};
                    }
                    for (k = 0; k < npt; ++k) {
                        w[ndim + k] = Math.abs(w[ndim + k]);
                    }
                }
            }
            gotoL120 = false;
            double dsqmin = 0.0;
            for (k = 0; k < npt; ++k) {
                double wndimk = w[ndim + k];
                if (!(wndimk > 0.0) || dsqmin != 0.0 && !(wndimk < dsqmin)) continue;
                knew = k;
                dsqmin = wndimk;
            }
            if (dsqmin == 0.0) break;
            for (j4 = 0; j4 < n; ++j4) {
                w[npt + j4] = xpt[knew][j4];
            }
            for (k = 0; k < npt; ++k) {
                sum = 0.0;
                if (k != kopt) {
                    if (ptsid[k] == 0.0) {
                        for (j = 0; j < n; ++j) {
                            sum += w[npt + j] * xpt[k][j];
                        }
                    } else {
                        int iq;
                        ip = (int)ptsid[k];
                        if (ip > 0) {
                            sum = w[npt + ip] * ptsaux[0][ip];
                        }
                        if ((iq = (int)((double)np * ptsid[k] - (double)(ip * np))) > 0) {
                            int iw = 0;
                            if (ip == 0) {
                                iw = 1;
                            }
                            sum += w[npt + iq] * ptsaux[iw][iq];
                        }
                    }
                }
                w[k] = 0.5 * sum * sum;
            }
            for (k = 0; k < npt; ++k) {
                sum = 0.0;
                for (j = 0; j < n; ++j) {
                    sum += bmat[k][j] * w[npt + j];
                }
                vlag[k] = sum;
            }
            beta = 0.0;
            for (j4 = 0; j4 < nptm; ++j4) {
                int k2;
                sum = 0.0;
                for (k2 = 0; k2 < npt; ++k2) {
                    sum += zmat[k2][j4] * w[k2];
                }
                beta -= sum * sum;
                for (k2 = 0; k2 < npt; ++k2) {
                    int n2 = k2;
                    vlag[n2] = vlag[n2] + sum * zmat[k2][j4];
                }
            }
            double bsum = 0.0;
            double distsq = 0.0;
            for (int j6 = 0; j6 < n; ++j6) {
                double sum2 = 0.0;
                for (int k3 = 0; k3 < npt; ++k3) {
                    sum2 += bmat[k3][j6] * w[k3];
                }
                int jp = j6 + npt;
                bsum += sum2 * w[jp];
                for (int ip3 = npt; ip3 < ndim; ++ip3) {
                    sum2 += bmat[ip3][j6] * w[ip3];
                }
                bsum += sum2 * w[jp];
                vlag[jp] = sum2;
                sum2 = xpt[knew][j6];
                distsq += sum2 * sum2;
            }
            beta = 0.5 * distsq * distsq + beta - bsum;
            vlag[kopt] = vlag[kopt] + 1.0;
            denom = 0.0;
            double vlmxsq = 0.0;
            for (int k4 = 0; k4 < npt; ++k4) {
                double vlagksq = vlag[k4];
                vlagksq *= vlagksq;
                if (ptsid[k4] != 0.0) {
                    double hdiag = 0.0;
                    for (int j7 = 0; j7 < nptm; ++j7) {
                        hdiag += zmat[k4][j7] * zmat[k4][j7];
                    }
                    double den = beta * hdiag + vlagksq;
                    if (den > denom) {
                        kold = k4;
                        denom = den;
                    }
                }
                vlmxsq = Math.max(vlmxsq, vlagksq);
            }
            if (!(denom <= 0.01 * vlmxsq)) continue;
            w[ndim + knew] = -w[ndim + knew] - winc;
            gotoL120 = true;
        }
        for (int kpt = 0; kpt < npt; ++kpt) {
            double f;
            double xp = 0.0;
            double xq = 0.0;
            if (ptsid[kpt] < 0.0) continue;
            if (nf >= maxfun) {
                nf = -1;
                break;
            }
            ih = 0;
            for (j = 0; j < n; ++j) {
                w[j] = xpt[kpt][j];
                xpt[kpt][j] = 0.0;
                double temp6 = pq[kpt] * w[j];
                for (int i2 = 0; i2 <= j; ++i2) {
                    hq[ih] = hq[ih] + temp6 * w[i2];
                    ++ih;
                }
            }
            pq[kpt] = 0.0;
            ip = (int)ptsid[kpt];
            int iq = (int)((double)np * ptsid[kpt] - (double)(ip * np));
            if (ip >= 0) {
                xpt[kpt][ip] = xp = ptsaux[0][ip];
            }
            if (iq >= 0) {
                xpt[kpt][iq] = xq = ptsaux[ip == 0 ? 1 : 0][iq];
            }
            double vquad = fbase;
            int ihp = 0;
            int ihq = 0;
            if (ip >= 0) {
                ihp = (ip + ip * ip) / 2;
                vquad += xp * (gopt[ip] + 0.5 * xp * hq[ihp - 1]);
            }
            if (iq >= 0) {
                ihq = (iq + iq * iq) / 2;
                vquad += xq * (gopt[iq] + 0.5 * xq * hq[ihq - 1]);
                if (ip >= 0) {
                    int iw = Math.max(ihp, ihq) - Math.abs(ip - iq);
                    vquad += xp * xq * hq[iw - 1];
                }
            }
            for (int k = 0; k < npt; ++k) {
                double temp7 = 0.0;
                if (ip >= 0) {
                    temp7 += xp * xpt[k][ip];
                }
                if (iq >= 0) {
                    temp7 += xq * xpt[k][iq];
                }
                vquad += 0.5 * pq[k] * temp7 * temp7;
            }
            for (int i3 = 0; i3 < n; ++i3) {
                w[i3] = Math.min(Math.max(xl[i3], xbase[i3] + xpt[kpt][i3]), xu[i3]);
                if (xpt[kpt][i3] == sl[i3]) {
                    w[i3] = xl[i3];
                }
                if (xpt[kpt][i3] != su[i3]) continue;
                w[i3] = xu[i3];
            }
            ++nf;
            fval[kpt] = f = calfun.eval(w) * (double)mult;
            if (f < fval[kopt]) {
                kopt = kpt;
            }
            double diff = f - vquad;
            for (int i4 = 0; i4 < n; ++i4) {
                gopt[i4] = gopt[i4] + diff * bmat[kpt][i4];
            }
            for (int k = 0; k < npt; ++k) {
                double val;
                double sum = 0.0;
                for (int j8 = 0; j8 < nptm; ++j8) {
                    sum += zmat[k][j8] * zmat[kpt][j8];
                }
                double temp8 = diff * sum;
                if (ptsid[k] < 0.0) {
                    pq[k] = pq[k] + temp8;
                    continue;
                }
                ip = (int)ptsid[k];
                iq = (int)((double)np * ptsid[k] - (double)(ip * np));
                ihq = (iq * iq + iq) / 2;
                if (ip == 0) {
                    val = ptsaux[1][iq];
                    hq[ihq] = hq[ihq] + temp8 * val * val;
                    continue;
                }
                ihp = (ip * ip + ip) / 2;
                val = ptsaux[0][ip];
                hq[ihp] = hq[ihp] + temp8 * val * val;
                if (iq < 0) continue;
                double val2 = ptsaux[0][iq];
                hq[ihq] = hq[ihq] + temp8 * val2 * val2;
                int iw = Math.max(ihp, ihq) - Math.abs(iq - ip);
                hq[iw] = hq[iw] + temp8 * val * val2;
            }
            ptsid[kpt] = -1.0;
        }
        return new int[]{nf, kopt};
    }

    private static final double[] altmov(double[][] xpt, double[] xopt, double[][] bmat, double[][] zmat, double[] sl, double[] su, int kopt, int knew, double adelt, double[] xnew, double[] xalt) {
        double cauchy;
        int n = xpt[0].length;
        int npt = xpt.length;
        double __const = 1.0 + Math.sqrt(2.0);
        double[] glag = new double[n];
        double[] hcol = new double[npt];
        double[] w = new double[2 * n];
        for (int k = 0; k < npt; ++k) {
            hcol[k] = 0.0;
        }
        for (int j = 0; j < npt - n - 1; ++j) {
            double temp = zmat[knew][j];
            for (int k = 0; k < npt; ++k) {
                hcol[k] = hcol[k] + temp * zmat[k][j];
            }
        }
        double alpha = hcol[knew];
        double ha = 0.5 * alpha;
        for (int i = 0; i < n; ++i) {
            glag[i] = bmat[knew][i];
        }
        for (int k = 0; k < npt; ++k) {
            double temp = 0.0;
            for (int j = 0; j < n; ++j) {
                temp += xpt[k][j] * xopt[j];
            }
            temp *= hcol[k];
            for (int i = 0; i < n; ++i) {
                glag[i] = glag[i] + temp * xpt[k][i];
            }
        }
        double presav = 0.0;
        double stpsav = 0.0;
        int ksav = 0;
        int ibdsav = 0;
        for (int k = 0; k < npt; ++k) {
            double temp;
            double vlag;
            if (k == kopt) continue;
            double dderiv = 0.0;
            double distsq = 0.0;
            for (int i = 0; i < n; ++i) {
                double temp2 = xpt[k][i] - xopt[i];
                dderiv += glag[i] * temp2;
                distsq += temp2 * temp2;
            }
            double subd = adelt / Math.sqrt(distsq);
            double slbd = -subd;
            double sumin = Math.min(1.0, subd);
            int ilbd = 0;
            int iubd = 0;
            for (int i = 0; i < n; ++i) {
                double temp3 = xpt[k][i] - xopt[i];
                if (temp3 > 0.0) {
                    if (slbd * temp3 < sl[i] - xopt[i]) {
                        slbd = (sl[i] - xopt[i]) / temp3;
                        ilbd = -i - 1;
                    }
                    if (!(subd * temp3 > su[i] - xopt[i])) continue;
                    subd = Math.max(sumin, (su[i] - xopt[i]) / temp3);
                    iubd = i + 1;
                    continue;
                }
                if (!(temp3 < 0.0)) continue;
                if (slbd * temp3 > su[i] - xopt[i]) {
                    slbd = (su[i] - xopt[i]) / temp3;
                    ilbd = i + 1;
                }
                if (!(subd * temp3 < sl[i] - xopt[i])) continue;
                subd = Math.max(sumin, (sl[i] - xopt[i]) / temp3);
                iubd = -i - 1;
            }
            double step = slbd;
            int isbd = ilbd;
            if (k == knew) {
                double tempb;
                double tempd;
                double tempa;
                double diff = dderiv - 1.0;
                vlag = slbd * (dderiv - slbd * diff);
                temp = subd * (dderiv - subd * diff);
                if (Math.abs(temp) > Math.abs(vlag)) {
                    step = subd;
                    vlag = temp;
                    isbd = iubd;
                }
                if ((tempa = (tempd = 0.5 * dderiv) - diff * slbd) * (tempb = tempd - diff * subd) < 0.0 && Math.abs(temp = tempd * tempd / diff) > Math.abs(vlag)) {
                    step = tempd / diff;
                    vlag = temp;
                    isbd = 0;
                }
            } else {
                vlag = slbd * (1.0 - slbd);
                temp = subd * (1.0 - subd);
                if (Math.abs(temp) > Math.abs(vlag)) {
                    step = subd;
                    vlag = temp;
                    isbd = iubd;
                }
                if (subd > 0.5 && Math.abs(vlag) < 0.25) {
                    step = 0.5;
                    vlag = 0.25;
                    isbd = 0;
                }
                vlag *= dderiv;
            }
            temp = step * (1.0 - step) * distsq;
            double predsq = vlag * vlag * (vlag * vlag + ha * temp * temp);
            if (!(predsq > presav)) continue;
            presav = predsq;
            ksav = k;
            stpsav = step;
            ibdsav = isbd;
        }
        for (int i = 0; i < n; ++i) {
            double temp = xopt[i] + stpsav * (xpt[ksav][i] - xopt[i]);
            xnew[i] = Math.max(sl[i], Math.min(su[i], temp));
        }
        if (ibdsav < 0) {
            xnew[-ibdsav - 1] = sl[-ibdsav - 1];
        } else if (ibdsav > 0) {
            xnew[ibdsav - 1] = su[ibdsav - 1];
        }
        double bigstp = adelt + adelt;
        boolean iflag = false;
        double csave = 0.0;
        while (true) {
            double temp;
            double wsqsav;
            double wfixsq = 0.0;
            double ggfree = 0.0;
            for (int i = 0; i < n; ++i) {
                w[i] = 0.0;
                double glagi = glag[i];
                if (!(Math.min(xopt[i] - sl[i], glagi) > 0.0) && !(Math.max(xopt[i] - su[i], glagi) < 0.0)) continue;
                w[i] = bigstp;
                ggfree += glagi * glagi;
            }
            if (ggfree == 0.0) {
                return new double[]{alpha, 0.0};
            }
            double step = 0.0;
            do {
                double d;
                temp = adelt * adelt - wfixsq;
                if (!(d > 0.0)) break;
                wsqsav = wfixsq;
                step = Math.sqrt(temp / ggfree);
                ggfree = 0.0;
                for (int i = 0; i < n; ++i) {
                    double wi;
                    if (w[i] != bigstp) continue;
                    temp = xopt[i] - step * glag[i];
                    if (temp <= sl[i]) {
                        wi = w[i] = sl[i] - xopt[i];
                        wfixsq += wi * wi;
                        continue;
                    }
                    if (temp >= su[i]) {
                        wi = w[i] = su[i] - xopt[i];
                        wfixsq += wi * wi;
                        continue;
                    }
                    wi = glag[i];
                    ggfree += wi * wi;
                }
            } while (wfixsq > wsqsav && ggfree > 0.0);
            double gw = 0.0;
            for (int i = 0; i < n; ++i) {
                double glagi = glag[i];
                if (w[i] == bigstp) {
                    w[i] = -step * glagi;
                    xalt[i] = Math.max(sl[i], Math.min(su[i], xopt[i] + w[i]));
                } else {
                    xalt[i] = w[i] == 0.0 ? xopt[i] : (glagi > 0.0 ? sl[i] : su[i]);
                }
                gw += glagi * w[i];
            }
            double curv = 0.0;
            for (int k = 0; k < npt; ++k) {
                temp = 0.0;
                for (int j = 0; j < n; ++j) {
                    temp += xpt[k][j] * w[j];
                }
                curv += hcol[k] * temp * temp;
            }
            if (iflag) {
                curv = -curv;
            }
            if (curv > -gw && curv < -gw * __const) {
                double scale = -gw / curv;
                for (int i = 0; i < n; ++i) {
                    temp = xopt[i] + scale * w[i];
                    xalt[i] = Math.max(sl[i], Math.min(su[i], temp));
                }
                cauchy = 0.5 * gw * scale;
                cauchy *= cauchy;
            } else {
                cauchy = gw + 0.5 * curv;
                cauchy *= cauchy;
            }
            if (iflag) break;
            for (int i = 0; i < n; ++i) {
                glag[i] = -glag[i];
                w[n + i] = xalt[i];
            }
            csave = cauchy;
            iflag = true;
        }
        if (csave > cauchy) {
            for (int i = 0; i < n; ++i) {
                xalt[i] = w[n + i];
            }
            cauchy = csave;
        }
        return new double[]{alpha, cauchy};
    }

    private static final double[] trsbox(double[][] xpt, double[] xopt, double[] gopt, double[] hq, double[] pq, double[] sl, double[] su, double delta, double[] xnew, double[] d, double[] gnew, double dsq, double crvmin) {
        double val;
        int i;
        int n = xpt[0].length;
        int npt = xpt.length;
        int iterc = 0;
        int nact = 0;
        int[] xbdi = new int[n];
        double[] s = new double[n];
        double[] hs = new double[n];
        double[] hred = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            xbdi[i2] = 0;
            if (xopt[i2] <= sl[i2]) {
                if (gopt[i2] >= 0.0) {
                    xbdi[i2] = -1;
                }
            } else if (xopt[i2] >= su[i2] && gopt[i2] <= 0.0) {
                xbdi[i2] = 1;
            }
            if (xbdi[i2] != 0) {
                ++nact;
            }
            d[i2] = 0.0;
            gnew[i2] = gopt[i2];
        }
        double delsq = delta * delta;
        double qred = 0.0;
        double beta = 0.0;
        double gredsq = 0.0;
        double dredsq = 0.0;
        double dredg = 0.0;
        double ggsav = 0.0;
        double stepsq = 0.0;
        double sredg = 0.0;
        double redsav = 0.0;
        double angbd = 1.0;
        int itermax = 0;
        int itcsav = 0;
        int label = 30;
        int xsav = 0;
        int iact = 0;
        crvmin = -1.0;
        boolean loop = true;
        while (loop) {
            switch (label) {
                case 30: {
                    stepsq = 0.0;
                    for (i = 0; i < n; ++i) {
                        s[i] = xbdi[i] != 0 ? 0.0 : (beta == 0.0 ? -gnew[i] : beta * s[i] - gnew[i]);
                        val = s[i];
                        stepsq += val * val;
                    }
                    if (stepsq == 0.0) {
                        loop = false;
                        break;
                    }
                    if (beta == 0.0) {
                        gredsq = stepsq;
                        itermax = iterc + n - nact;
                    }
                    if (gredsq * delsq <= qred * 1.0E-4 * qred) {
                        loop = false;
                        break;
                    }
                    label = 210;
                    break;
                }
                case 50: {
                    double resid = delsq;
                    double ds = 0.0;
                    double shs = 0.0;
                    for (int i3 = 0; i3 < n; ++i3) {
                        if (xbdi[i3] != 0) continue;
                        double di = d[i3];
                        double si = s[i3];
                        resid -= di * di;
                        ds += si * di;
                        shs += si * hs[i3];
                    }
                    if (resid <= 0.0) {
                        crvmin = 0.0;
                        label = 100;
                        break;
                    }
                    double temp = Math.sqrt(stepsq * resid + ds * ds);
                    double blen = ds < 0.0 ? (temp - ds) / stepsq : resid / (temp + ds);
                    double stplen = shs > 0.0 ? Math.min(blen, gredsq / shs) : blen;
                    iact = -1;
                    for (int i4 = 0; i4 < n; ++i4) {
                        if (s[i4] == 0.0) continue;
                        double xsum = xopt[i4] + d[i4];
                        double d2 = temp = s[i4] > 0.0 ? (su[i4] - xsum) / s[i4] : (sl[i4] - xsum) / s[i4];
                        if (!(temp < stplen)) continue;
                        stplen = temp;
                        iact = i4;
                    }
                    double sdec = 0.0;
                    if (stplen > 0.0) {
                        ++iterc;
                        temp = shs / stepsq;
                        if (iact == -1 && temp > 0.0 && (crvmin = Math.min(crvmin, temp)) == -1.0) {
                            crvmin = temp;
                        }
                        ggsav = gredsq;
                        gredsq = 0.0;
                        for (int i5 = 0; i5 < n; ++i5) {
                            gnew[i5] = gnew[i5] + stplen * hs[i5];
                            if (xbdi[i5] == 0) {
                                double val2 = gnew[i5];
                                gredsq += val2 * val2;
                            }
                            d[i5] = d[i5] + stplen * s[i5];
                        }
                        sdec = Math.max(stplen * (ggsav - 0.5 * stplen * shs), 0.0);
                        qred += sdec;
                    }
                    if (iact >= 0) {
                        double val3;
                        ++nact;
                        xbdi[iact] = 1;
                        if (s[iact] < 0.0) {
                            xbdi[iact] = -1;
                        }
                        if ((delsq -= (val3 = d[iact]) * val3) <= 0.0) {
                            crvmin = 0.0;
                            label = 100;
                            break;
                        }
                        beta = 0.0;
                        label = 30;
                        break;
                    }
                    if (stplen < blen) {
                        if (iterc == itermax || sdec <= 0.01 * qred) {
                            loop = false;
                            break;
                        }
                        beta = gredsq / ggsav;
                        label = 30;
                        break;
                    }
                    crvmin = 0.0;
                    label = 100;
                    break;
                }
                case 100: {
                    if (nact >= n - 1) {
                        loop = false;
                        break;
                    }
                    gredsq = 0.0;
                    dredg = 0.0;
                    dredsq = 0.0;
                    for (int i6 = 0; i6 < n; ++i6) {
                        if (xbdi[i6] == 0) {
                            double di = d[i6];
                            double gi = gnew[i6];
                            dredsq += di * di;
                            dredg += di * gi;
                            gredsq += gi * gi;
                            s[i6] = di;
                            continue;
                        }
                        s[i6] = 0.0;
                    }
                    itcsav = iterc;
                    label = 210;
                    break;
                }
                case 120: {
                    int i7;
                    ++iterc;
                    double temp = gredsq * dredsq - dredg * dredg;
                    if (temp <= qred * 1.0E-4 * qred) {
                        loop = false;
                        break;
                    }
                    temp = Math.sqrt(temp);
                    for (i7 = 0; i7 < n; ++i7) {
                        s[i7] = xbdi[i7] == 0 ? (dredg * d[i7] - dredsq * gnew[i7]) / temp : 0.0;
                    }
                    sredg = -temp;
                    angbd = 1.0;
                    iact = -1;
                    label = 0;
                    for (i7 = 0; i7 < n; ++i7) {
                        if (xbdi[i7] != 0) continue;
                        double tempa = xopt[i7] + d[i7] - sl[i7];
                        double tempb = su[i7] - xopt[i7] - d[i7];
                        if (tempa <= 0.0) {
                            ++nact;
                            xbdi[i7] = -1;
                            label = 100;
                            break;
                        }
                        if (tempb <= 0.0) {
                            ++nact;
                            xbdi[i7] = 1;
                            label = 100;
                            break;
                        }
                        double di = d[i7];
                        double si = s[i7];
                        double ssq = di * di + si * si;
                        double val4 = xopt[i7] - sl[i7];
                        temp = ssq - val4 * val4;
                        if (temp > 0.0 && angbd * (temp = Math.sqrt(temp) - s[i7]) > tempa) {
                            angbd = tempa / temp;
                            iact = i7;
                            xsav = -1;
                        }
                        if (!((temp = ssq - (val4 = su[i7] - xopt[i7]) * val4) > 0.0) || !(angbd * (temp = Math.sqrt(temp) + s[i7]) > tempb)) continue;
                        angbd = tempb / temp;
                        iact = i7;
                        xsav = 1;
                    }
                    if (label != 0) break;
                    label = 210;
                    break;
                }
                case 150: {
                    double sth;
                    double dhs = 0.0;
                    double dhd = 0.0;
                    double shs = 0.0;
                    for (int i8 = 0; i8 < n; ++i8) {
                        if (xbdi[i8] != 0) continue;
                        shs += s[i8] * hs[i8];
                        dhs += d[i8] * hs[i8];
                        dhd += d[i8] * hred[i8];
                    }
                    redsav = 0.0;
                    double redmax = 0.0;
                    double rdprev = 0.0;
                    double rdnext = 0.0;
                    double angt = 0.0;
                    int isav = 0;
                    int iu = (int)(17.0 * angbd + 3.1);
                    for (int i9 = 1; i9 <= iu; ++i9) {
                        angt = angbd * (double)i9 / (double)iu;
                        sth = (angt + angt) / (1.0 + angt * angt);
                        double temp = shs + angt * (angt * dhd - dhs - dhs);
                        double rednew = sth * (angt * dredg - sredg - 0.5 * sth * temp);
                        if (rednew > redmax) {
                            redmax = rednew;
                            isav = i9;
                            rdprev = redsav;
                        } else if (i9 == isav + 1) {
                            rdnext = rednew;
                        }
                        redsav = rednew;
                    }
                    if (isav == 0) {
                        loop = false;
                        break;
                    }
                    if (isav < iu) {
                        double temp = (rdnext - rdprev) / (redmax + redmax - rdprev - rdnext);
                        angt = angbd * ((double)isav + 0.5 * temp) / (double)iu;
                    }
                    double cth = (1.0 - angt * angt) / (1.0 + angt * angt);
                    sth = (angt + angt) / (1.0 + angt * angt);
                    double temp = shs + angt * (angt * dhd - dhs - dhs);
                    double sdec = sth * (angt * dredg - sredg - 0.5 * sth * temp);
                    if (sdec <= 0.0) {
                        loop = false;
                        break;
                    }
                    gredsq = 0.0;
                    dredg = 0.0;
                    for (int i10 = 0; i10 < n; ++i10) {
                        gnew[i10] = gnew[i10] + (cth - 1.0) * hred[i10] + sth * hs[i10];
                        if (xbdi[i10] == 0) {
                            d[i10] = cth * d[i10] + sth * s[i10];
                            double val5 = gnew[i10];
                            dredg += d[i10] * val5;
                            gredsq += val5 * val5;
                        }
                        hred[i10] = cth * hred[i10] + sth * hs[i10];
                    }
                    qred += sdec;
                    if (iact >= 0 && isav == iu) {
                        ++nact;
                        xbdi[iact] = xsav;
                        label = 100;
                        break;
                    }
                    if (sdec > 0.01 * qred) {
                        label = 120;
                        break;
                    }
                    loop = false;
                    break;
                }
                case 210: {
                    int i11;
                    int ih = 0;
                    for (int j = 0; j < n; ++j) {
                        hs[j] = 0.0;
                        for (i11 = 0; i11 <= j; ++i11) {
                            if (i11 < j) {
                                hs[j] = hs[j] + hq[ih] * s[i11];
                            }
                            hs[i11] = hs[i11] + hq[ih] * s[j];
                            ++ih;
                        }
                    }
                    for (int k = 0; k < npt; ++k) {
                        if (pq[k] == 0.0) continue;
                        double temp = 0.0;
                        for (int j = 0; j < n; ++j) {
                            temp += xpt[k][j] * s[j];
                        }
                        temp *= pq[k];
                        for (i11 = 0; i11 < n; ++i11) {
                            hs[i11] = hs[i11] + temp * xpt[k][i11];
                        }
                    }
                    if (crvmin != 0.0) {
                        label = 50;
                        break;
                    }
                    if (iterc > itcsav) {
                        label = 150;
                        break;
                    }
                    for (int i12 = 0; i12 < n; ++i12) {
                        hred[i12] = hs[i12];
                    }
                    label = 120;
                }
            }
        }
        dsq = 0.0;
        for (i = 0; i < n; ++i) {
            xnew[i] = Math.max(Math.min(xopt[i] + d[i], su[i]), sl[i]);
            if (xbdi[i] == -1) {
                xnew[i] = sl[i];
            }
            if (xbdi[i] == 1) {
                xnew[i] = su[i];
            }
            val = d[i] = xnew[i] - xopt[i];
            dsq += val * val;
        }
        return new double[]{dsq, crvmin};
    }

    public static void main(String[] args) {
        MultivariableFunction ifun = new MultivariableFunction(){

            @Override
            public double eval(double ... x) {
                int n = x.length;
                double f = 0.0;
                for (int i = 3; i < n; i += 2) {
                    for (int j = 1; j < i - 1; j += 2) {
                        double v1 = x[i - 1] - x[j - 1];
                        double v2 = x[i] - x[j];
                        f += 1.0 / Math.sqrt(Math.max(v1 * v1 + v2 * v2, 1.0E-6));
                    }
                }
                return f;
            }
        };
        double rhobeg = 0.1;
        double rhoend = 1.0E-6;
        int maxfun = 500000;
        int max_n = 80;
        int n = 10;
        System.out.println("rhobeg = " + rhobeg + ", rhoend = " + rhoend);
        do {
            int i;
            int npt = n + 6;
            double[] xl = new double[n];
            double[] xu = new double[n];
            double[] x = new double[n];
            for (i = 0; i < n; ++i) {
                xl[i] = -1.0;
                xu[i] = 1.0;
            }
            for (i = 0; i < n / 2; ++i) {
                double temp = (double)((i + 1) * 4) * Math.PI / (double)n;
                x[2 * i] = Math.cos(temp);
                x[2 * i + 1] = Math.sin(temp);
            }
            System.out.println("n = " + n + ", npt = " + npt);
            OptimizationResult result = Bobyqa.bobyqa(x, xl, xu, ifun, npt, rhobeg, rhoend, maxfun, true);
            System.out.println(result);
            npt = 2 * n + 1;
            System.out.println("n = " + n + ", npt = " + npt);
            result = Bobyqa.bobyqa(x, xl, xu, ifun, npt, rhobeg, rhoend, maxfun, true);
            System.out.println(result);
        } while ((n *= 2) <= max_n);
    }
}

