/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Normal;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Kendall
extends GenericDistribution {
    protected int n;

    static final long count(int k, int n, long[][] w) {
        int i;
        int u = n * (n - 1) / 2;
        if (k < 0 || k > u) {
            return 0L;
        }
        if (w[n] == null) {
            w[n] = new long[u + 1];
            for (i = 0; i <= u; ++i) {
                w[n][i] = -1L;
            }
        }
        if (w[n][k] < 0L) {
            if (n == 1) {
                w[n][k] = k == 0 ? 1L : 0L;
            } else {
                long sum = 0L;
                for (i = 0; i < n; ++i) {
                    sum += Kendall.count(k - i, n - 1, w);
                }
                w[n][k] = sum;
            }
        }
        return w[n][k];
    }

    public static final double calculate_tau(double x, int n) {
        return (4.0 * x - 2.0) / (double)(n * (n - 1)) - 1.0;
    }

    public static final double calculate_count(double tau, int n) {
        return 0.5 + (1.0 + tau) * (double)n * (double)(n - 1) / 4.0;
    }

    public static final double density(double x, int n) {
        long[][] w = new long[n + 1][];
        if (MathFunctions.isNonInt(x) || x < 0.0 || x > (double)(n * (n - 1) / 2)) {
            return 0.0;
        }
        return (double)Kendall.count((int)x, n, w) / MathFunctions.gammafn(n + 1);
    }

    public static final double density_tau(double tau, int n) {
        return Kendall.density(Kendall.calculate_count(tau, n), n);
    }

    public static final double cumulative(double x, int n) {
        long[][] w = new long[n + 1][];
        double q = Math.floor(x + 1.0E-7);
        if (q < 0.0) {
            return 0.0;
        }
        if (q > (double)(n * (n - 1) / 2)) {
            return 1.0;
        }
        double p = 0.0;
        int j = 0;
        while ((double)j <= q) {
            p += (double)Kendall.count(j, n, w);
            ++j;
        }
        return Math.exp(Math.log(p) - MathFunctions.lgammafn(n + 1));
    }

    public static final double cumulative_tau(double tau, int n) {
        return Kendall.cumulative(Kendall.calculate_count(tau, n), n);
    }

    public static final double quantile(double p, int n) {
        if (Double.isNaN(p) || MathFunctions.isInfinite(p)) {
            return p;
        }
        if (p < 0.0 || p > 1.0 || n < 2) {
            return Double.NaN;
        }
        double mu = (double)(n * (n - 1)) / 4.0;
        double sigma = Math.sqrt(((double)n * (2.0 * (double)n + 1.0) * (double)(n + 1) / 6.0 - (double)n) / 12.0);
        long k = (long)(sigma * Normal.quantile(p, 0.0, 1.0, true, false) + mu + 0.5);
        if (p <= Kendall.cumulative(k, n)) {
            do {
                if (!(p > Kendall.cumulative(--k, n))) continue;
                return (double)k + 1.5;
            } while (k > 0L);
        } else {
            while (!(p <= Kendall.cumulative(++k, n))) {
            }
            return (double)k + 0.5;
        }
        return (double)k + 0.5;
    }

    public static final double quantile_tau(double p, int n) {
        return Kendall.calculate_count(Kendall.quantile(p, n), n);
    }

    public static final double random(int n, RandomEngine random) {
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Kendall.quantile(u1 / 1.34217728E8, n);
        return u1;
    }

    public static final double[] random(int count, int n, RandomEngine random) {
        double[] rand = new double[count];
        for (int i = 0; i < count; ++i) {
            rand[i] = Kendall.random(n, random);
        }
        return rand;
    }

    public Kendall(int n) {
        this.n = n;
    }

    @Override
    public double density(double x, boolean log) {
        return log ? Math.log(Kendall.density(x, this.n)) : Kendall.density(x, this.n);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        p = Kendall.cumulative(p, this.n);
        return log_p ? Math.log(lower_tail ? p : 1.0 - p) : (lower_tail ? p : 1.0 - p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        if (log_p) {
            q = Math.exp(q);
        }
        if (!lower_tail) {
            q = 1.0 - q;
        }
        return Kendall.quantile(q, this.n);
    }

    @Override
    public double random() {
        return Kendall.random(this.n, this.random);
    }
}

