/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Exponential;
import jdistlib.Normal;
import jdistlib.Poisson;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Gamma
extends GenericDistribution {
    static final double M_cutoff = 3.196577161300664E18;
    protected double shape;
    protected double scale;

    public static final double density(double x, double shape, double scale, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(shape) || Double.isNaN(scale)) {
            return x + shape + scale;
        }
        if (shape < 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (shape == 0.0) {
            return x == 0.0 ? Double.POSITIVE_INFINITY : (give_log ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (x == 0.0) {
            if (shape < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (shape > 1.0) {
                return give_log ? Double.NEGATIVE_INFINITY : 0.0;
            }
            return give_log ? -Math.log(scale) : 1.0 / scale;
        }
        if (shape < 1.0) {
            double pr = Poisson.density_raw(shape, x / scale, give_log);
            return give_log ? pr + Math.log(shape / x) : pr * shape / x;
        }
        double pr = Poisson.density_raw(shape - 1.0, x / scale, give_log);
        return give_log ? pr - Math.log(scale) : pr / scale;
    }

    static final double dpois_wrap(double x_plus_1, double lambda, boolean give_log) {
        if (MathFunctions.isInfinite(lambda)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x_plus_1 > 1.0) {
            return Poisson.density_raw(x_plus_1 - 1.0, lambda, give_log);
        }
        if (lambda > Math.abs(x_plus_1 - 1.0) * 3.196577161300664E18) {
            lambda = -lambda - MathFunctions.lgammafn(x_plus_1);
            return give_log ? lambda : Math.exp(lambda);
        }
        double d = Poisson.density_raw(x_plus_1, lambda, give_log);
        return give_log ? d + Math.log(x_plus_1 / lambda) : d * (x_plus_1 / lambda);
    }

    static final double pgamma_smallx(double x, double alph, boolean lower_tail, boolean log_p) {
        double term;
        double sum = 0.0;
        double c = alph;
        double n = 0.0;
        while (Math.abs(term = (c *= -x / (n += 1.0)) / (alph + n)) > 2.220446049250313E-16 * Math.abs(sum += term)) {
        }
        if (lower_tail) {
            double f2;
            double f1;
            double d = f1 = log_p ? Math.log1p(sum) : 1.0 + sum;
            if (alph > 1.0) {
                f2 = Poisson.density_raw(alph, x, log_p);
                f2 = log_p ? f2 + x : f2 * Math.exp(x);
            } else {
                f2 = log_p ? alph * Math.log(x) - MathFunctions.lgamma1p(alph) : Math.pow(x, alph) / Math.exp(MathFunctions.lgamma1p(alph));
            }
            return log_p ? f1 + f2 : f1 * f2;
        }
        double lf2 = alph * Math.log(x) - MathFunctions.lgamma1p(alph);
        if (log_p) {
            lf2 = Math.log1p(sum) + lf2;
            return lf2 > -0.6931471805599453 ? Math.log(-Math.expm1(lf2)) : Math.log1p(-Math.exp(lf2));
        }
        double f1m1 = sum;
        double f2m1 = Math.expm1(lf2);
        return -(f1m1 + f2m1 + f1m1 * f2m1);
    }

    static final double dpnorm(double x, boolean lower_tail, double lp) {
        if (x < 0.0) {
            x = -x;
            boolean bl = lower_tail = !lower_tail;
        }
        if (x > 10.0 && !lower_tail) {
            double term;
            double sum = term = 1.0 / x;
            double x2 = x * x;
            double i = 1.0;
            while (Math.abs(term) > 2.220446049250313E-16 * (sum += (term *= -(i += 2.0) / x2))) {
            }
            return 1.0 / sum;
        }
        return Normal.density(x, 0.0, 1.0, false) / Math.exp(lp);
    }

    static final double ppois_asymp(double x, double lambda, boolean lower_tail, boolean log_p) {
        int i;
        double res2_term;
        double res1_term;
        double[] coefs_a = new double[]{-1.0E99, 0.6666666666666666, -0.02962962962962963, 0.0028218694885361554, 0.0018812463256907702, -7.119598889146215E-4, -6.783725850941215E-4, 4.728641948577934E-4};
        double[] coefs_b = new double[]{-1.0E99, 0.08333333333333333, 0.003472222222222222, -0.0026813271604938273, -2.2947209362139917E-4, 7.840392217200666E-4, 6.972813758365857E-5, -5.921664373536939E-4};
        double dfm = lambda - x;
        double pt_ = -MathFunctions.log1pmx(dfm / x);
        double s2pt = Math.sqrt(2.0 * x * pt_);
        if (dfm < 0.0) {
            s2pt = -s2pt;
        }
        double res12 = 0.0;
        double res1_ig = res1_term = Math.sqrt(x);
        double res2_ig = res2_term = s2pt;
        for (i = 1; i < 8; ++i) {
            res12 += res1_ig * coefs_a[i];
            res12 += res2_ig * coefs_b[i];
            res1_ig = res1_ig / x + (res1_term *= pt_ / (double)i);
            res2_ig = res2_ig / x + (res2_term *= 2.0 * pt_ / (double)(2 * i + 1));
        }
        double elfb = x;
        double elfb_term = 1.0;
        for (i = 1; i < 8; ++i) {
            elfb += elfb_term * coefs_b[i];
            elfb_term /= x;
        }
        if (!lower_tail) {
            elfb = -elfb;
        }
        double f = res12 / elfb;
        double np = Normal.cumulative(s2pt, 0.0, 1.0, !lower_tail, log_p);
        if (log_p) {
            double n_d_over_p = Gamma.dpnorm(s2pt, !lower_tail, np);
            return np + Math.log1p(f * n_d_over_p);
        }
        double nd = Normal.density(s2pt, 0.0, 1.0, log_p);
        return np + f * nd;
    }

    static final double pgamma_raw(double x, double alph, boolean lower_tail, boolean log_p) {
        double res;
        if (x <= 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (double)(!log_p ? 1 : 0);
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return lower_tail ? (double)(!log_p ? 1 : 0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (x < 1.0) {
            res = Gamma.pgamma_smallx(x, alph, lower_tail, log_p);
        } else if (x <= alph - 1.0 && x < 0.8 * (alph + 50.0)) {
            double sum = MathFunctions.pd_upper_series(x, alph, log_p);
            double d = Gamma.dpois_wrap(alph, x, log_p);
            res = !lower_tail ? (log_p ? ((res = d + sum) > -0.6931471805599453 ? Math.log(-Math.expm1(res)) : Math.log1p(-Math.exp(res))) : 1.0 - d * sum) : (log_p ? sum + d : sum * d);
        } else if (alph - 1.0 < x && alph < 0.8 * (x + 50.0)) {
            double sum;
            double d = Gamma.dpois_wrap(alph, x, log_p);
            if (alph < 1.0) {
                if (x * 2.220446049250313E-16 > 1.0 - alph) {
                    sum = log_p ? 0.0 : 1.0;
                } else {
                    double f = MathFunctions.pd_lower_cf(alph, x - (alph - 1.0)) * x / alph;
                    sum = log_p ? Math.log(f) : f;
                }
            } else {
                sum = MathFunctions.pd_lower_series(x, alph - 1.0);
                double d2 = sum = log_p ? Math.log1p(sum) : 1.0 + sum;
            }
            res = !lower_tail ? (log_p ? sum + d : sum * d) : (log_p ? ((res = d + sum) > -0.6931471805599453 ? Math.log(-Math.expm1(res)) : Math.log1p(-Math.exp(res))) : 1.0 - d * sum);
        } else {
            res = Gamma.ppois_asymp(alph - 1.0, x, !lower_tail, log_p);
        }
        if (!log_p && res < 1.0020841800044864E-292) {
            return Math.exp(Gamma.pgamma_raw(x, alph, lower_tail, true));
        }
        return res;
    }

    public static final double cumulative(double x, double alph, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(alph) || Double.isNaN(scale)) {
            return x + alph + scale;
        }
        if (alph < 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        if (Double.isNaN(x /= scale)) {
            return x;
        }
        if (alph == 0.0) {
            return x <= 0.0 ? (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0)) : (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0));
        }
        return Gamma.pgamma_raw(x, alph, lower_tail, log_p);
    }

    static final double qchisq_appr(double p, double nu, double g, boolean lower_tail, boolean log_p, double tol) {
        double ch;
        double p1;
        double C7 = 4.67;
        double C8 = 6.66;
        double C9 = 6.73;
        double C10 = 13.32;
        if (Double.isNaN(p) || Double.isNaN(nu)) {
            return p + nu;
        }
        if (log_p && p > 0.0 || !log_p && (p < 0.0 || p > 1.0)) {
            return Double.NaN;
        }
        if (nu <= 0.0) {
            return Double.NaN;
        }
        double alpha = 0.5 * nu;
        double c = alpha - 1.0;
        double d = lower_tail ? (log_p ? p : Math.log(p)) : (log_p ? (p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) : (p1 = Math.log1p(-p)));
        if (nu < -1.24 * p1) {
            double lgam1pa = alpha < 0.5 ? MathFunctions.lgamma1p(alpha) : Math.log(alpha) + g;
            ch = Math.exp((lgam1pa + p1) / alpha + 0.6931471805599453);
        } else if (nu > 0.32) {
            double x = Normal.quantile(p, 0.0, 1.0, lower_tail, log_p);
            ch = nu * Math.pow(x * Math.sqrt(p1 = 2.0 / (9.0 * nu)) + 1.0 - p1, 3.0);
            if (ch > 2.2 * nu + 6.0) {
                ch = -2.0 * ((lower_tail ? (log_p ? (p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) : Math.log1p(-p)) : (log_p ? p : Math.log(p))) - c * Math.log(0.5 * ch) + g);
            }
        } else {
            double t;
            double p2;
            double q;
            ch = 0.4;
            double a = (lower_tail ? (log_p ? (p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) : Math.log1p(-p)) : (log_p ? p : Math.log(p))) + g + c * 0.6931471805599453;
            do {
                q = ch;
                p1 = 1.0 / (1.0 + ch * (4.67 + ch));
                p2 = ch * (6.73 + ch * (6.66 + ch));
                t = -0.5 + (4.67 + 2.0 * ch) * p1 - (6.73 + ch * (13.32 + 3.0 * ch)) / p2;
            } while (Math.abs(q - (ch -= (1.0 - Math.exp(a + 0.5 * ch) * p2 * p1) / t)) > tol * Math.abs(ch));
        }
        return ch;
    }

    public static final double quantile(double p, double alpha, double scale, boolean lower_tail, boolean log_p) {
        double t;
        double p1;
        int i;
        double EPS1 = 0.01;
        double EPS2 = 5.0E-7;
        double EPS_N = 1.0E-15;
        double pMIN = 1.0E-100;
        double pMAX = 0.99999999999999;
        int MAXIT = 1000;
        double i420 = 0.002380952380952381;
        double i2520 = 3.968253968253968E-4;
        double i5040 = 1.984126984126984E-4;
        int max_it_Newton = 1;
        if (Double.isNaN(p) || Double.isNaN(alpha) || Double.isNaN(scale)) {
            return p + alpha + scale;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        if (alpha < 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        if (alpha == 0.0) {
            return 0.0;
        }
        if (alpha < 1.0E-10) {
            max_it_Newton = 7;
        }
        double p_ = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (lower_tail ? p : 0.5 - p + 0.5);
        double g = MathFunctions.lgammafn(alpha);
        double ch = Gamma.qchisq_appr(p, 2.0 * alpha, g, lower_tail, log_p, 0.01);
        if (MathFunctions.isInfinite(ch)) {
            max_it_Newton = 0;
        } else if (ch < 5.0E-7) {
            max_it_Newton = 20;
        } else if (p_ > 0.99999999999999 || p_ < 1.0E-100) {
            max_it_Newton = 20;
        } else {
            double c = alpha - 1.0;
            double s6 = (120.0 + c * (346.0 + 127.0 * c)) * 1.984126984126984E-4;
            double ch0 = ch;
            for (i = 1; i <= 1000; ++i) {
                double s5;
                double s4;
                double s3;
                double s2;
                double b;
                double a;
                double s1;
                double q = ch;
                p1 = 0.5 * ch;
                double p2 = p_ - Gamma.pgamma_raw(p1, alpha, true, false);
                if (MathFunctions.isInfinite(p2) || ch <= 0.0) {
                    ch = ch0;
                    max_it_Newton = 27;
                    break;
                }
                if (Math.abs(q - (ch += (t = p2 * Math.exp(alpha * 0.6931471805599453 + g + p1 - c * Math.log(ch))) * (1.0 + 0.5 * t * (s1 = (210.0 + (a = 0.5 * t - (b = t / ch) * c) * (140.0 + a * (105.0 + a * (84.0 + a * (70.0 + 60.0 * a))))) * 0.002380952380952381) - b * c * (s1 - b * ((s2 = (420.0 + a * (735.0 + a * (966.0 + a * (1141.0 + 1278.0 * a)))) * 3.968253968253968E-4) - b * ((s3 = (210.0 + a * (462.0 + a * (707.0 + 932.0 * a))) * 3.968253968253968E-4) - b * ((s4 = (252.0 + a * (672.0 + 1182.0 * a) + c * (294.0 + a * (889.0 + 1740.0 * a))) * 1.984126984126984E-4) - b * ((s5 = (84.0 + 2264.0 * a + c * (1175.0 + 606.0 * a)) * 3.968253968253968E-4) - b * s6)))))))) < 5.0E-7 * ch) break;
                if (!(Math.abs(q - ch) > 0.1 * ch)) continue;
                ch = ch < q ? 0.9 * q : 1.1 * q;
            }
        }
        double x = 0.5 * scale * ch;
        if (max_it_Newton != 0) {
            if (!log_p) {
                p = Math.log(p);
                log_p = true;
            }
            if (x == 0.0) {
                double _1_p = 1.0000001;
                double _1_m = 0.9999999;
                x = Double.MIN_NORMAL;
                p_ = Gamma.cumulative(x, alpha, scale, lower_tail, log_p);
                if (lower_tail && p_ > p * 1.0000001 || !lower_tail && p_ < p * 0.9999999) {
                    return 0.0;
                }
            } else {
                p_ = Gamma.cumulative(x, alpha, scale, lower_tail, log_p);
            }
            if (p_ == Double.NEGATIVE_INFINITY) {
                return 0.0;
            }
            for (i = 1; i <= max_it_Newton && !(Math.abs(p1 = p_ - p) < Math.abs(1.0E-15 * p)) && (g = Gamma.density(x, alpha, scale, log_p)) != 0.0; ++i) {
                t = log_p ? p1 * Math.exp(p_ - g) : p1 / g;
                t = lower_tail ? x - t : x + t;
                p_ = Gamma.cumulative(t, alpha, scale, lower_tail, log_p);
                if (Math.abs(p_ - p) > Math.abs(p1) || i > 1 && Math.abs(p_ - p) == Math.abs(p1)) break;
                x = t;
            }
        }
        return x;
    }

    public static final double random(double a, double scale, RandomEngine random) {
        double q;
        double v;
        double c;
        double si;
        double b;
        double sqrt32 = 5.656854;
        double exp_m1 = 0.36787944117144233;
        double q1 = 0.04166669;
        double q2 = 0.02083148;
        double q3 = 0.00801191;
        double q4 = 0.00144121;
        double q5 = -7.388E-5;
        double q6 = 2.4511E-4;
        double q7 = 2.424E-4;
        double a1 = 0.3333333;
        double a2 = -0.250003;
        double a3 = 0.2000062;
        double a4 = -0.1662921;
        double a5 = 0.1423657;
        double a6 = -0.1367177;
        double a7 = 0.1233795;
        if (Double.isNaN(a) || Double.isNaN(scale)) {
            return Double.NaN;
        }
        if (a <= 0.0 || scale <= 0.0) {
            if (scale == 0.0 || a == 0.0) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(a) || MathFunctions.isInfinite(scale)) {
            return Double.POSITIVE_INFINITY;
        }
        if (a < 1.0) {
            double x;
            double e = 1.0 + 0.36787944117144233 * a;
            while (true) {
                double p;
                if ((p = e * random.nextDouble()) >= 1.0) {
                    x = -Math.log((e - p) / a);
                    if (!(Exponential.random_standard(random) >= (1.0 - a) * Math.log(x))) continue;
                    break;
                }
                x = Math.exp(Math.log(p) / a);
                if (Exponential.random_standard(random) >= x) break;
            }
            return scale * x;
        }
        double s2 = a - 0.5;
        double s = Math.sqrt(s2);
        double d = 5.656854 - s * 12.0;
        double t = Normal.random_standard(random);
        double x = s + 0.5 * t;
        double ret_val = x * x;
        if (t >= 0.0) {
            return scale * ret_val;
        }
        double u = random.nextDouble();
        if (d * u <= t * t * t) {
            return scale * ret_val;
        }
        double r = 1.0 / a;
        double q0 = ((((((2.424E-4 * r + 2.4511E-4) * r + -7.388E-5) * r + 0.00144121) * r + 0.00801191) * r + 0.02083148) * r + 0.04166669) * r;
        if (a <= 3.686) {
            b = 0.463 + s + 0.178 * s2;
            si = 1.235;
            c = 0.195 / s - 0.079 + 0.16 * s;
        } else if (a <= 13.022) {
            b = 1.654 + 0.0076 * s2;
            si = 1.68 / s + 0.275;
            c = 0.062 / s + 0.024;
        } else {
            b = 1.77;
            si = 0.75;
            c = 0.1515 / s;
        }
        if (x > 0.0) {
            v = t / (s + s);
            q = Math.abs(v) <= 0.25 ? q0 + 0.5 * t * t * ((((((0.1233795 * v + -0.1367177) * v + 0.1423657) * v + -0.1662921) * v + 0.2000062) * v + -0.250003) * v + 0.3333333) * v : q0 - s * t + 0.25 * t * t + (s2 + s2) * Math.log(1.0 + v);
            if (Math.log(1.0 - u) <= q) {
                return scale * ret_val;
            }
        }
        while (true) {
            double e = Exponential.random_standard(random);
            u = random.nextDouble();
            t = (u = u + u - 1.0) < 0.0 ? b - si * e : b + si * e;
            if (!(t >= -0.71874483771719) || !((q = Math.abs(v = t / (s + s)) <= 0.25 ? q0 + 0.5 * t * t * ((((((0.1233795 * v + -0.1367177) * v + 0.1423657) * v + -0.1662921) * v + 0.2000062) * v + -0.250003) * v + 0.3333333) * v : q0 - s * t + 0.25 * t * t + (s2 + s2) * Math.log(1.0 + v)) > 0.0)) continue;
            double w = Math.expm1(q);
            if (c * Math.abs(u) <= w * Math.exp(e - 0.5 * t * t)) break;
        }
        x = s + 0.5 * t;
        return scale * x * x;
    }

    public static final double[] random(int n, double a, double scale, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Gamma.random(a, scale, random);
        }
        return rand;
    }

    public Gamma(double shape, double scale) {
        this.shape = shape;
        this.scale = scale;
    }

    @Override
    public double density(double x, boolean log) {
        return Gamma.density(x, this.shape, this.scale, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Gamma.cumulative(p, this.shape, this.scale, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Gamma.quantile(q, this.shape, this.scale, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Gamma.random(this.shape, this.scale, this.random);
    }
}

