/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class Arcsine
extends GenericDistribution {
    protected double a;
    protected double b;

    public static final double density(double x, double a, double b, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return x + a + b;
        }
        if (b < a) {
            throw new IllegalArgumentException();
        }
        b = -1.1447298858494002 - 0.5 * (Math.log(x - a) + Math.log(b - x));
        return give_log ? b : Math.exp(b);
    }

    public static final double cumulative(double x, double a, double b, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return x + a + b;
        }
        if (b < a) {
            throw new IllegalArgumentException();
        }
        b = Arcsine.cumulative_raw(x, a, b);
        return log_p ? (lower_tail ? b : Math.log1p(-Math.exp(b))) : (lower_tail ? Math.exp(b) : 1.0 - Math.exp(b));
    }

    static final double cumulative_raw(double x, double a, double b) {
        return -Math.log(1.5707963267948966) - Math.log(Math.asin(Math.sqrt((x - a) / (b - a))));
    }

    public static final double quantile(double q, double a, double b, boolean lower_tail, boolean log_p) {
        double mid;
        double f_mid;
        if (Double.isNaN(q) || Double.isNaN(a) || Double.isNaN(b)) {
            return q + a + b;
        }
        if (b < a) {
            throw new IllegalArgumentException();
        }
        if (log_p) {
            q = Math.exp(q);
        }
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException();
        }
        if (lower_tail) {
            q = 1.0 - q;
        }
        q = Math.log(q);
        double lo = a;
        double hi = b;
        double f_lo = Arcsine.cumulative_raw(lo, a, b);
        double f_hi = Arcsine.cumulative_raw(hi, a, b);
        boolean pathological = false;
        do {
            if ((f_mid = Arcsine.cumulative_raw(mid = (lo + hi) / 2.0, a, b)) == q && (f_hi == q || f_lo == q) && hi - lo > 2.0) {
                pathological = true;
            }
            if (lower_tail) {
                if (f_lo >= q) {
                    return lo;
                }
                if (f_mid > q) {
                    hi = mid;
                    f_hi = f_mid;
                    continue;
                }
                lo = mid;
                f_lo = f_mid;
                continue;
            }
            if (f_hi <= q) {
                return hi;
            }
            if (f_mid < q) {
                lo = mid;
                f_lo = f_mid;
                continue;
            }
            hi = mid;
            f_hi = f_mid;
        } while (hi - lo > 1.0);
        if (pathological) {
            System.err.println("Pathological case of Arcsine.quantile! Quantile estimate may not be accurate!");
        }
        if (lower_tail) {
            return f_hi <= q ? hi : (f_mid <= q ? mid : lo);
        }
        return f_lo >= q ? lo : (f_mid >= q ? mid : hi);
    }

    public static final double random(double a, double b, RandomEngine random) {
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Arcsine.quantile(u1 / 1.34217728E8, a, b, true, false);
        return u1;
    }

    public static final double[] random(int n, double a, double b, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Arcsine.random(a, b, random);
        }
        return rand;
    }

    public Arcsine(double a, double b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public double density(double x, boolean log) {
        return Arcsine.density(x, this.a, this.b, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Arcsine.cumulative(p, this.a, this.b, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Arcsine.quantile(q, this.a, this.b, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Arcsine.random(this.a, this.b, this.random);
    }
}

