/*
 * Decompiled with CFR 0.152.
 */
package org.ea.javacnn.readers;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ea.javacnn.readers.Reader;

public class PGMReader
implements Reader {
    private int imageSizeX = -1;
    private int imageSizeY = -1;
    private int maxvalue = -1;
    private List<String> labels;
    private String imagePath;
    private List<String> filenames = new ArrayList<String>();
    private boolean readLabel = false;
    private boolean readImage = false;
    private int currentImage = 0;
    private int headerSize = 0;

    public PGMReader(String imagePath) {
        this.imagePath = imagePath;
        File dir = new File(imagePath);
        HashSet<String> labels = new HashSet<String>();
        for (File f : dir.listFiles()) {
            if (!f.isFile()) continue;
            this.filenames.add(f.getName());
            labels.add(f.getName().split("_")[0]);
        }
        this.labels = new ArrayList<String>();
        this.labels.addAll(labels);
        try {
            String line;
            String filename = this.filenames.get(0);
            FileReader fr = new FileReader(new File(imagePath, filename));
            BufferedReader br = new BufferedReader(fr);
            boolean foundHeader = false;
            while ((line = br.readLine()) != null) {
                if (line.equals("P5")) {
                    foundHeader = true;
                } else {
                    if (line.startsWith("#")) continue;
                    if (line.matches("[0-9]+ [0-9]+")) {
                        String[] sizes = line.split(" ");
                        this.imageSizeX = Integer.parseInt(sizes[0]);
                        this.imageSizeY = Integer.parseInt(sizes[1]);
                    } else if (line.matches("[0-9]+")) {
                        this.maxvalue = Integer.parseInt(line);
                    } else {
                        throw new Exception("Unsupported file format");
                    }
                }
                ++this.headerSize;
                if (this.maxvalue == -1 || !foundHeader || this.imageSizeX == -1) continue;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void incrementCounter() {
        ++this.currentImage;
        this.readLabel = false;
        this.readImage = false;
    }

    @Override
    public int readNextLabel() {
        if (this.readLabel) {
            this.incrementCounter();
        }
        String filename = this.filenames.get(this.currentImage);
        int label = this.labels.indexOf(filename.split("_")[0]);
        if (this.readImage) {
            this.incrementCounter();
        } else {
            this.readLabel = true;
        }
        return label;
    }

    @Override
    public int[] readNextImage() throws Exception {
        if (this.readImage) {
            this.incrementCounter();
        }
        if (this.currentImage >= this.size()) {
            return new int[0];
        }
        String filename = this.filenames.get(this.currentImage);
        FileInputStream fis = new FileInputStream(new File(this.imagePath, filename));
        DataInputStream dis = new DataInputStream(fis);
        for (int numNewlines = this.headerSize; numNewlines > 0; --numNewlines) {
            char c;
            while ((c = (char)dis.readUnsignedByte()) != '\n') {
            }
        }
        int[] returnData = new int[this.imageSizeX * this.imageSizeY];
        for (int i = 0; i < this.imageSizeX * this.imageSizeY; ++i) {
            returnData[i] = dis.readUnsignedByte();
        }
        if (this.readLabel) {
            this.incrementCounter();
        } else {
            this.readImage = true;
        }
        return returnData;
    }

    @Override
    public void reset() {
        this.currentImage = 0;
        this.readLabel = false;
        this.readImage = false;
    }

    @Override
    public int numOfClasses() {
        return this.labels.size();
    }

    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public int size() {
        return this.filenames.size();
    }

    @Override
    public int getSizeX() {
        return this.imageSizeX;
    }

    @Override
    public int getSizeY() {
        return this.imageSizeY;
    }

    @Override
    public int getMaxvalue() {
        return this.maxvalue;
    }

    public static void main(String[] argv) {
        int i;
        PGMReader mr = new PGMReader("pgmfiles/train");
        System.out.println(mr.size());
        for (i = 0; i < mr.size(); ++i) {
            System.out.print(mr.readNextLabel());
        }
        mr.reset();
        for (i = 0; i < mr.size(); ++i) {
            try {
                mr.readNextImage();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Crash at " + i);
            }
        }
        mr.reset();
        try {
            int[] b = mr.readNextImage();
            for (int j = 0; j < b.length; ++j) {
                if (j % mr.getSizeX() == 0) {
                    System.out.println();
                }
                System.out.print(b[j] + " ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

