/*
 * Decompiled with CFR 0.152.
 */
package edu.hitsz.c102c.cnn;

import edu.hitsz.c102c.util.Log;
import edu.hitsz.c102c.util.Util;
import java.io.Serializable;

public class Layer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LayerType type;
    private int outMapNum;
    private Size mapSize;
    private Size kernelSize;
    private Size scaleSize;
    private double[][][][] kernel;
    private double[] bias;
    private double[][][][] outmaps;
    private double[][][][] errors;
    private static int recordInBatch = 0;
    private int classNum = -1;
    static int count = 0;

    private Layer() {
    }

    public static void prepareForNewBatch() {
        recordInBatch = 0;
    }

    public static void prepareForNewRecord() {
        ++recordInBatch;
    }

    public static Layer buildInputLayer(Size mapSize) {
        Layer layer = new Layer();
        layer.type = LayerType.input;
        layer.outMapNum = 1;
        layer.setMapSize(mapSize);
        return layer;
    }

    public static Layer buildConvLayer(int outMapNum, Size kernelSize) {
        Layer layer = new Layer();
        layer.type = LayerType.conv;
        layer.outMapNum = outMapNum;
        layer.kernelSize = kernelSize;
        return layer;
    }

    public static Layer buildSampLayer(Size scaleSize) {
        Layer layer = new Layer();
        layer.type = LayerType.samp;
        layer.scaleSize = scaleSize;
        return layer;
    }

    public static Layer buildOutputLayer(int classNum) {
        Layer layer = new Layer();
        layer.classNum = classNum;
        layer.type = LayerType.output;
        layer.mapSize = new Size(1, 1);
        layer.outMapNum = classNum;
        Log.i("outMapNum:" + layer.outMapNum);
        return layer;
    }

    public Size getMapSize() {
        return this.mapSize;
    }

    public void setMapSize(Size mapSize) {
        this.mapSize = mapSize;
    }

    public LayerType getType() {
        return this.type;
    }

    public int getOutMapNum() {
        return this.outMapNum;
    }

    public void setOutMapNum(int outMapNum) {
        this.outMapNum = outMapNum;
    }

    public Size getKernelSize() {
        return this.kernelSize;
    }

    public Size getScaleSize() {
        return this.scaleSize;
    }

    public void initKernel(int frontMapNum) {
        this.kernel = new double[frontMapNum][this.outMapNum][this.kernelSize.x][this.kernelSize.y];
        for (int i = 0; i < frontMapNum; ++i) {
            for (int j = 0; j < this.outMapNum; ++j) {
                this.kernel[i][j] = Util.randomMatrix(this.kernelSize.x, this.kernelSize.y, true);
            }
        }
    }

    public void initOutputKerkel(int frontMapNum, Size size) {
        this.kernelSize = size;
        this.kernel = new double[frontMapNum][this.outMapNum][this.kernelSize.x][this.kernelSize.y];
        for (int i = 0; i < frontMapNum; ++i) {
            for (int j = 0; j < this.outMapNum; ++j) {
                this.kernel[i][j] = Util.randomMatrix(this.kernelSize.x, this.kernelSize.y, false);
            }
        }
    }

    public void initBias(int frontMapNum) {
        this.bias = Util.randomArray(this.outMapNum);
    }

    public void initOutmaps(int batchSize) {
        this.outmaps = new double[batchSize][this.outMapNum][this.mapSize.x][this.mapSize.y];
    }

    public void setMapValue(int mapNo, int mapX, int mapY, double value) {
        this.outmaps[Layer.recordInBatch][mapNo][mapX][mapY] = value;
    }

    public void setMapValue(int mapNo, double[][] outMatrix) {
        this.outmaps[Layer.recordInBatch][mapNo] = outMatrix;
    }

    public double[][] getMap(int index) {
        return this.outmaps[recordInBatch][index];
    }

    public double[][] getKernel(int i, int j) {
        return this.kernel[i][j];
    }

    public void setError(int mapNo, int mapX, int mapY, double value) {
        this.errors[Layer.recordInBatch][mapNo][mapX][mapY] = value;
    }

    public void setError(int mapNo, double[][] matrix) {
        this.errors[Layer.recordInBatch][mapNo] = matrix;
    }

    public double[][] getError(int mapNo) {
        return this.errors[recordInBatch][mapNo];
    }

    public double[][][][] getErrors() {
        return this.errors;
    }

    public void initErros(int batchSize) {
        this.errors = new double[batchSize][this.outMapNum][this.mapSize.x][this.mapSize.y];
    }

    public void setKernel(int lastMapNo, int mapNo, double[][] kernel) {
        this.kernel[lastMapNo][mapNo] = kernel;
    }

    public double getBias(int mapNo) {
        return this.bias[mapNo];
    }

    public void setBias(int mapNo, double value) {
        this.bias[mapNo] = value;
    }

    public double[][][][] getMaps() {
        return this.outmaps;
    }

    public double[][] getError(int recordId, int mapNo) {
        return this.errors[recordId][mapNo];
    }

    public double[][] getMap(int recordId, int mapNo) {
        return this.outmaps[recordId][mapNo];
    }

    public int getClassNum() {
        return this.classNum;
    }

    public double[][][][] getKernel() {
        return this.kernel;
    }

    public static class Size
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int x;
        public final int y;

        public Size(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("Size(").append(" x = ").append(this.x).append(" y= ").append(this.y).append(")");
            return s.toString();
        }

        public Size divide(Size scaleSize) {
            int x = this.x / scaleSize.x;
            int y = this.y / scaleSize.y;
            if (x * scaleSize.x != this.x || y * scaleSize.y != this.y) {
                throw new RuntimeException(this + "\u00b2\u00bb\u00c4\u00dc\u00d5\u00fb\u00b3\u00fd" + scaleSize);
            }
            return new Size(x, y);
        }

        public Size subtract(Size size, int append) {
            int x = this.x - size.x + append;
            int y = this.y - size.y + append;
            return new Size(x, y);
        }
    }

    static enum LayerType {
        input,
        output,
        conv,
        samp;

    }
}

