/*
 * Decompiled with CFR 0.152.
 */
package edu.hitsz.c102c.cnn;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Dataset {
    private List<Record> records;
    private int lableIndex;
    private double maxLable = -1.0;

    public Dataset(int classIndex) {
        this.lableIndex = classIndex;
        this.records = new ArrayList<Record>();
    }

    public Dataset(List<double[]> datas) {
        this();
        for (double[] data : datas) {
            this.append(new Record(data));
        }
    }

    private Dataset() {
        this.lableIndex = -1;
        this.records = new ArrayList<Record>();
    }

    public int size() {
        return this.records.size();
    }

    public int getLableIndex() {
        return this.lableIndex;
    }

    public void append(Record record) {
        this.records.add(record);
    }

    public void clear() {
        this.records.clear();
    }

    public void append(double[] attrs, Double lable) {
        this.records.add(new Record(attrs, lable));
    }

    public Iterator<Record> iter() {
        return this.records.iterator();
    }

    public double[] getAttrs(int index) {
        return this.records.get(index).getAttrs();
    }

    public Double getLable(int index) {
        return this.records.get(index).getLable();
    }

    public static Dataset load(String filePath, String tag, int lableIndex) {
        Dataset dataset = new Dataset();
        dataset.lableIndex = lableIndex;
        File file = new File(filePath);
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] datas = line.split(tag);
                if (datas.length == 0) continue;
                double[] data = new double[datas.length];
                for (int i = 0; i < datas.length; ++i) {
                    data[i] = Double.parseDouble(datas[i]);
                }
                Dataset dataset2 = dataset;
                dataset2.getClass();
                Record record = dataset2.new Record(data);
                dataset.append(record);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        System.out.println("Import Data:" + dataset.size());
        return dataset;
    }

    public static void main(String[] args) {
        Dataset d = new Dataset();
        d.lableIndex = 10;
        Dataset dataset = d;
        dataset.getClass();
        Record r = dataset.new Record(new double[]{3.0, 2.0, 2.0, 5.0, 4.0, 5.0, 3.0, 11.0, 3.0, 12.0, 1.0});
        int[] encode = r.getEncodeTarget(4);
        System.out.println(r.lable);
        System.out.println(Arrays.toString(encode));
    }

    public Record getRecord(int index) {
        return this.records.get(index);
    }

    public class Record {
        private double[] attrs;
        private Double lable;

        private Record(double[] attrs, Double lable) {
            this.attrs = attrs;
            this.lable = lable;
        }

        public Record(double[] data) {
            if (Dataset.this.lableIndex == -1) {
                this.attrs = data;
            } else {
                this.lable = data[Dataset.this.lableIndex];
                if (this.lable > Dataset.this.maxLable) {
                    Dataset.this.maxLable = this.lable;
                }
                this.attrs = Dataset.this.lableIndex == 0 ? Arrays.copyOfRange(data, 1, data.length) : Arrays.copyOfRange(data, 0, data.length - 1);
            }
        }

        public double[] getAttrs() {
            return this.attrs;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("attrs:");
            sb.append(Arrays.toString(this.attrs));
            sb.append("lable:");
            sb.append(this.lable);
            return sb.toString();
        }

        public Double getLable() {
            if (Dataset.this.lableIndex == -1) {
                return null;
            }
            return this.lable;
        }

        public int[] getEncodeTarget(int n) {
            String binary = Integer.toBinaryString(this.lable.intValue());
            byte[] bytes = binary.getBytes();
            int[] encode = new int[n];
            int j = n;
            for (int i = bytes.length - 1; i >= 0; --i) {
                encode[--j] = bytes[i] - 48;
            }
            return encode;
        }

        public double[] getDoubleEncodeTarget(int n) {
            String binary = Integer.toBinaryString(this.lable.intValue());
            byte[] bytes = binary.getBytes();
            double[] encode = new double[n];
            int j = n;
            for (int i = bytes.length - 1; i >= 0; --i) {
                encode[--j] = bytes[i] - 48;
            }
            return encode;
        }
    }
}

