/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.swing.models;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.lucene.swing.models.BaseListModel;
import org.apache.lucene.swing.models.DataStore;
import org.apache.lucene.swing.models.ListSearcher;

public class ListSearcherSimulator {
    public ListSearcherSimulator() {
        JFrame frame = new JFrame();
        frame.setBounds(200, 200, 400, 250);
        JList list = new JList();
        JScrollPane scrollPane = new JScrollPane(list);
        BaseListModel listModel = new BaseListModel(DataStore.getRestaurants());
        final ListSearcher listSearcher = new ListSearcher(listModel);
        list.setModel(listSearcher);
        final JTextField searchField = new JTextField();
        searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                listSearcher.search(searchField.getText().trim().toLowerCase());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                listSearcher.search(searchField.getText().trim().toLowerCase());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                listSearcher.search(searchField.getText().trim().toLowerCase());
            }
        });
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)scrollPane, "Center");
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BorderLayout(10, 10));
        searchPanel.add((Component)searchField, "Center");
        searchPanel.add((Component)new JLabel("Search: "), "West");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)searchPanel, "Center");
        topPanel.add((Component)new JPanel(), "East");
        topPanel.add((Component)new JPanel(), "West");
        topPanel.add((Component)new JPanel(), "North");
        topPanel.add((Component)new JPanel(), "South");
        frame.getContentPane().add((Component)topPanel, "North");
        frame.setTitle("Lucene powered table searching");
        frame.setDefaultCloseOperation(3);
        frame.show();
    }

    public static void main(String[] args) {
        new ListSearcherSimulator();
    }
}

