/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;

public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;

    public IndexSearcher(String path) throws CorruptIndexException, IOException {
        this(IndexReader.open(path), true);
    }

    public IndexSearcher(Directory directory) throws CorruptIndexException, IOException {
        this(IndexReader.open(directory), true);
    }

    public IndexSearcher(IndexReader r) {
        this(r, false);
    }

    private IndexSearcher(IndexReader r, boolean closeReader) {
        this.reader = r;
        this.closeReader = closeReader;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    @Override
    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    @Override
    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    @Override
    public Document doc(int i) throws CorruptIndexException, IOException {
        return this.reader.document(i);
    }

    @Override
    public Document doc(int i, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.reader.document(i, fieldSelector);
    }

    @Override
    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        if (nDocs <= 0) {
            throw new IllegalArgumentException("nDocs must be > 0");
        }
        TopDocCollector collector = new TopDocCollector(nDocs);
        this.search(weight, filter, (HitCollector)collector);
        return collector.topDocs();
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        TopFieldDocCollector collector = new TopFieldDocCollector(this.reader, sort, nDocs);
        this.search(weight, filter, (HitCollector)collector);
        return (TopFieldDocs)collector.topDocs();
    }

    @Override
    public void search(Weight weight, Filter filter, final HitCollector results) throws IOException {
        Scorer scorer;
        HitCollector collector = results;
        if (filter != null) {
            final BitSet bits = filter.bits(this.reader);
            collector = new HitCollector(){

                @Override
                public final void collect(int doc, float score) {
                    if (bits.get(doc)) {
                        results.collect(doc, score);
                    }
                }
            };
        }
        if ((scorer = weight.scorer(this.reader)) == null) {
            return;
        }
        scorer.score(collector);
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        return query;
    }

    @Override
    public Explanation explain(Weight weight, int doc) throws IOException {
        return weight.explain(this.reader, doc);
    }
}

