/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.analyzing;

import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.analyzing.ASCIIAnalyzer;
import org.apache.lucene.queryParser.analyzing.AnalyzingQueryParser;
import org.apache.lucene.search.Query;

public class TestAnalyzingQueryParser
extends TestCase {
    private Analyzer a;
    private String[] wildcardInput;
    private String[] wildcardExpected;
    private String[] prefixInput;
    private String[] prefixExpected;
    private String[] rangeInput;
    private String[] rangeExpected;
    private String[] fuzzyInput;
    private String[] fuzzyExpected;

    public void setUp() {
        this.wildcardInput = new String[]{"\u00fcbersetzung \u00fcber*ung", "M\u00f6tley Cr\u00fce M\u00f6tl?* Cr\u00fc?", "Ren\u00e9e Zellweger Ren?? Zellw?ger"};
        this.wildcardExpected = new String[]{"ubersetzung uber*ung", "motley crue motl?* cru?", "renee zellweger ren?? zellw?ger"};
        this.prefixInput = new String[]{"\u00fcbersetzung \u00fcbersetz*", "M\u00f6tley Cr\u00fce M\u00f6tl* cr\u00fc*", "Ren\u00e9? Zellw*"};
        this.prefixExpected = new String[]{"ubersetzung ubersetz*", "motley crue motl* cru*", "rene? zellw*"};
        this.rangeInput = new String[]{"[aa TO bb]", "{Ana\u00efs TO Zo\u00e9}"};
        this.rangeExpected = new String[]{"[aa TO bb]", "{anais TO zoe}"};
        this.fuzzyInput = new String[]{"\u00dcbersetzung \u00dcbersetzung~0.9", "M\u00f6tley Cr\u00fce M\u00f6tley~0.75 Cr\u00fce~0.5", "Ren\u00e9e Zellweger Ren\u00e9e~0.9 Zellweger~"};
        this.fuzzyExpected = new String[]{"ubersetzung ubersetzung~0.9", "motley crue motley~0.75 crue~0.5", "renee zellweger renee~0.9 zellweger~0.5"};
        this.a = new ASCIIAnalyzer();
    }

    public void testWildCardQuery() throws ParseException {
        for (int i = 0; i < this.wildcardInput.length; ++i) {
            TestAnalyzingQueryParser.assertEquals((String)("Testing wildcards with analyzer " + this.a.getClass() + ", input string: " + this.wildcardInput[i]), (String)this.wildcardExpected[i], (String)this.parseWithAnalyzingQueryParser(this.wildcardInput[i], this.a));
        }
    }

    public void testPrefixQuery() throws ParseException {
        for (int i = 0; i < this.prefixInput.length; ++i) {
            TestAnalyzingQueryParser.assertEquals((String)("Testing prefixes with analyzer " + this.a.getClass() + ", input string: " + this.prefixInput[i]), (String)this.prefixExpected[i], (String)this.parseWithAnalyzingQueryParser(this.prefixInput[i], this.a));
        }
    }

    public void testRangeQuery() throws ParseException {
        for (int i = 0; i < this.rangeInput.length; ++i) {
            TestAnalyzingQueryParser.assertEquals((String)("Testing ranges with analyzer " + this.a.getClass() + ", input string: " + this.rangeInput[i]), (String)this.rangeExpected[i], (String)this.parseWithAnalyzingQueryParser(this.rangeInput[i], this.a));
        }
    }

    public void testFuzzyQuery() throws ParseException {
        for (int i = 0; i < this.fuzzyInput.length; ++i) {
            TestAnalyzingQueryParser.assertEquals((String)("Testing fuzzys with analyzer " + this.a.getClass() + ", input string: " + this.fuzzyInput[i]), (String)this.fuzzyExpected[i], (String)this.parseWithAnalyzingQueryParser(this.fuzzyInput[i], this.a));
        }
    }

    private String parseWithAnalyzingQueryParser(String s, Analyzer a) throws ParseException {
        AnalyzingQueryParser qp = new AnalyzingQueryParser("field", a);
        Query q = qp.parse(s);
        return q.toString("field");
    }
}

