/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import junit.framework.TestCase;
import org.apache.lucene.misc.SweetSpotSimilarity;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Similarity;

public class SweetSpotSimilarityTest
extends TestCase {
    public void testSweetSpotLengthNorm() {
        int i;
        SweetSpotSimilarity ss = new SweetSpotSimilarity();
        ss.setLengthNormFactors(1, 1, 0.5f);
        DefaultSimilarity d = new DefaultSimilarity();
        SweetSpotSimilarity s = ss;
        for (i = 1; i < 1000; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("base case: i=" + i), (float)((Similarity)d).lengthNorm("foo", i), (float)((Similarity)s).lengthNorm("foo", i), (float)0.0f);
        }
        ss.setLengthNormFactors(3, 10, 0.5f);
        for (i = 3; i <= 10; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("3,10: spot i=" + i), (float)1.0f, (float)((Similarity)s).lengthNorm("foo", i), (float)0.0f);
        }
        for (i = 10; i < 1000; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("3,10: 10<x : i=" + i), (float)((Similarity)d).lengthNorm("foo", i - 9), (float)((Similarity)s).lengthNorm("foo", i), (float)0.0f);
        }
        ss.setLengthNormFactors("bar", 8, 13, 0.5f);
        ss.setLengthNormFactors("yak", 6, 9, 0.5f);
        for (i = 3; i <= 10; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("f: 3,10: spot i=" + i), (float)1.0f, (float)((Similarity)s).lengthNorm("foo", i), (float)0.0f);
        }
        for (i = 10; i < 1000; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("f: 3,10: 10<x : i=" + i), (float)((Similarity)d).lengthNorm("foo", i - 9), (float)((Similarity)s).lengthNorm("foo", i), (float)0.0f);
        }
        for (i = 8; i <= 13; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("f: 8,13: spot i=" + i), (float)1.0f, (float)((Similarity)s).lengthNorm("bar", i), (float)0.0f);
        }
        for (i = 6; i <= 9; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("f: 6,9: spot i=" + i), (float)1.0f, (float)((Similarity)s).lengthNorm("yak", i), (float)0.0f);
        }
        for (i = 13; i < 1000; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("f: 8,13: 13<x : i=" + i), (float)((Similarity)d).lengthNorm("foo", i - 12), (float)((Similarity)s).lengthNorm("bar", i), (float)0.0f);
        }
        for (i = 9; i < 1000; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("f: 6,9: 9<x : i=" + i), (float)((Similarity)d).lengthNorm("foo", i - 8), (float)((Similarity)s).lengthNorm("yak", i), (float)0.0f);
        }
        ss.setLengthNormFactors("a", 5, 8, 0.5f);
        ss.setLengthNormFactors("b", 5, 8, 0.1f);
        for (i = 9; i < 1000; ++i) {
            SweetSpotSimilarityTest.assertTrue((String)("s: i=" + i + " : a=" + ss.lengthNorm("a", i) + " < b=" + ss.lengthNorm("b", i)), (ss.lengthNorm("a", i) < ((Similarity)s).lengthNorm("b", i) ? 1 : 0) != 0);
        }
    }

    public void testSweetSpotTf() {
        int i;
        SweetSpotSimilarity ss = new SweetSpotSimilarity();
        DefaultSimilarity d = new DefaultSimilarity();
        SweetSpotSimilarity s = ss;
        ss.setBaselineTfFactors(0.0f, 0.0f);
        for (i = 1; i < 1000; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("tf: i=" + i), (float)d.tf(i), (float)((Similarity)s).tf(i), (float)0.0f);
        }
        ss.setBaselineTfFactors(1.0f, 0.0f);
        for (i = 1; i < 1000; ++i) {
            SweetSpotSimilarityTest.assertTrue((String)("tf: i=" + i + " : d=" + d.tf(i) + " < s=" + ((Similarity)s).tf(i)), (d.tf(i) < ((Similarity)s).tf(i) ? 1 : 0) != 0);
        }
        ss.setBaselineTfFactors(1.0f, 6.0f);
        for (i = 1; i <= 6; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("tf flat1: i=" + i), (float)1.0f, (float)((Similarity)s).tf(i), (float)0.0f);
        }
        ss.setBaselineTfFactors(2.0f, 6.0f);
        for (i = 1; i <= 6; ++i) {
            SweetSpotSimilarityTest.assertEquals((String)("tf flat2: i=" + i), (float)2.0f, (float)((Similarity)s).tf(i), (float)0.0f);
        }
        for (i = 6; i <= 1000; ++i) {
            SweetSpotSimilarityTest.assertTrue((String)("tf: i=" + i + " : s=" + ((Similarity)s).tf(i) + " < d=" + d.tf(i)), (((Similarity)s).tf(i) < d.tf(i) ? 1 : 0) != 0);
        }
        SweetSpotSimilarityTest.assertEquals((String)"tf zero", (float)0.0f, (float)((Similarity)s).tf(0), (float)0.0f);
    }

    public void testHyperbolicSweetSpot() {
        SweetSpotSimilarity ss = new SweetSpotSimilarity(){

            @Override
            public float tf(int freq) {
                return this.hyperbolicTf(freq);
            }
        };
        ss.setHyperbolicTfFactors(3.3f, 7.7f, Math.E, 5.0f);
        SweetSpotSimilarity s = ss;
        for (int i = 1; i <= 1000; ++i) {
            SweetSpotSimilarityTest.assertTrue((String)("MIN tf: i=" + i + " : s=" + ((Similarity)s).tf(i)), (3.3f <= ((Similarity)s).tf(i) ? 1 : 0) != 0);
            SweetSpotSimilarityTest.assertTrue((String)("MAX tf: i=" + i + " : s=" + ((Similarity)s).tf(i)), (((Similarity)s).tf(i) <= 7.7f ? 1 : 0) != 0);
        }
        SweetSpotSimilarityTest.assertEquals((String)"MID tf", (float)5.5f, (float)((Similarity)s).tf(5), (float)1.0E-5f);
        SweetSpotSimilarityTest.assertEquals((String)"tf zero", (float)0.0f, (float)((Similarity)s).tf(0), (float)0.0f);
    }
}

